set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6853410';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4244',
      '02320222',
      '03030434',
      '30243032',
      '40023111',
      '20203202',
      '10220203',
      '04010021',
      NULL,
      NULL,
      '34133304',
      '32232310',
      '20240112',
      '31211421',
      '20231344',
      '10331441',
      '23344110',
      NULL,
      '22140030',
      '31301420',
      '13232334',
      NULL,
      '23143033',
      '11101324',
      '31000024',
      NULL,
      '23141413',
      '11002123',
      '14032420',
      NULL,
      '24314102',
      '11221103',
      '42130021',
      '01411010',
      '33431022',
      '01223441',
      '10341110',
      '22434434',
      '13404440',
      '20231144',
      '40031431',
      '43222010',
      '34114340',
      '21033113',
      '33301002',
      '',
      '',
      NULL,
      NULL,
      '1203331',
      0.363493,
      0.192182,
      3,
      NULL,
      NULL,
      NULL,
      ' 1-26-1999',
      ' 4- 0-2000',
      NULL,
      NULL,
      18,
      11,
      18,
      14,
      43,
      12.620574,
      21,
      8,
      NULL,
      NULL,
      27,
      8.492182,
      NULL,
      NULL,
      27,
      NULL,
      16,
      NULL,
      23.297416,
      5.145451,
      NULL,
      0.600940,
      NULL,
      113,
      133,
      35.015329,
      NULL,
      11.089751,
      92.601296,
      NULL,
      29,
      53.970431,
      22.070460,
      24.914238,
      NULL,
      67.129902,
      ' 6- 3-1975',
      4,
      3,
      0,
      1.528992,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.804060,
      0.186932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1994',
      73.217642,
      8.444769,
      99.601151,
      8.504209,
      105,
      46,
      62.679558,
      NULL,
      31.138831,
      2,
      109,
      68.158658,
      ' 7- 4-1995',
      42.376818,
      31,
      29.500046,
      46,
      9,
      109,
      14.910931,
      ' 4-25-1986',
      25,
      NULL,
      ' 4-28-1999',
      3.155978,
      16.362773,
      NULL,
      10,
      24,
      2.029216,
      NULL,
      NULL,
      NULL,
      21.587215,
      3.813876,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      2,
      27,
      ' 1-21-1982',
      0.629269,
      87.311207,
      ' 8-15-1983',
      19.507068,
      11.386953,
      18,
      NULL,
      NULL,
      61,
      0.704050,
      223,
      ' 6-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.615768,
      NULL,
      NULL,
      99.324183,
      99,
      14.044216,
      35,
      NULL,
      4.669232,
      NULL,
      1.858085,
      1,
      NULL,
      1,
      0,
      53,
      1.780982,
      0,
      68.048953,
      4,
      1.139190,
      174,
      NULL,
      20.414634,
      NULL,
      0.956114,
      NULL,
      0.883596,
      0,
      0.612475,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      0.324223,
      0.411626,
      21.860942,
      1.978659,
      1.310757,
      1.626074,
      NULL,
      1,
      NULL,
      0.549265,
      NULL,
      1,
      1,
      NULL,
      31.438729,
      NULL,
      5.121040,
      NULL,
      NULL,
      21,
      NULL,
      6.313456,
      9.022696,
      NULL,
      8.487576,
      NULL,
      1,
      0.829133,
      3,
      NULL,
      ' 7- 4-1986',
      ' 9- 3-1990',
      '11-16-1992',
      ' 5-29-1986',
      NULL,
      ' 7-26-1974',
      ' 2- 5-1994',
      NULL);
commit;
end;
/


