set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9951361';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '3',
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      '0',
      '0',
      NULL,
      '0',
      '1',
      '0',
      '4',
      '1',
      '2',
      '0',
      '2',
      '3',
      '3',
      '',
      '2',
      NULL,
      '0',
      '2',
      '4',
      '2',
      NULL,
      '',
      '',
      '1',
      '4',
      '1',
      NULL,
      '0',
      '0',
      '0',
      '3',
      NULL,
      '0',
      '0',
      NULL,
      '21131143',
      66,
      NULL,
      '1121124',
      2,
      1.193386,
      NULL,
      1,
      '400212',
      4,
      NULL,
      ' 6-10-1985',
      71.206809,
      10.214123,
      20,
      19.325171,
      29,
      NULL,
      NULL,
      19.106082,
      9.539013,
      NULL,
      15.556956,
      18,
      24.726231,
      12,
      23,
      2,
      21.071582,
      19,
      8.009710,
      18.781723,
      32,
      21,
      95.446836,
      24,
      1,
      79.338995,
      NULL,
      100,
      92.036384,
      NULL,
      131,
      ' 9-28-1997',
      36.604326,
      10.693252,
      16,
      17,
      110,
      210.575780,
      ' 5- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      16.753803,
      7.406657,
      6,
      10,
      0.027691,
      ' 3-19-1976',
      0.574713,
      0,
      216,
      0.599419,
      1.841119,
      59.848932,
      NULL,
      0.307840,
      44.982815,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      19,
      NULL,
      25,
      47.866932,
      56.479121,
      52,
      45,
      44,
      2.888233,
      20,
      7,
      NULL,
      12,
      15.191245,
      26,
      93,
      NULL,
      NULL,
      NULL,
      NULL,
      17.123221,
      17,
      ' 2-23-1995',
      4.903335,
      14,
      11.777306,
      4,
      19,
      1,
      1,
      NULL,
      NULL,
      48,
      0,
      1.476362,
      21.031161,
      11,
      1,
      1.925868,
      1,
      0.039548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.181984,
      NULL,
      ' 9-16-1997',
      NULL,
      NULL,
      NULL,
      24.124349,
      NULL,
      21,
      NULL,
      5.302316,
      NULL,
      '10-26-1987',
      36.998624,
      NULL,
      ' 0-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      29,
      ' 0- 9-1994',
      7,
      10.345981,
      12,
      NULL,
      1.992913,
      41.306392,
      ' 8- 2-1985',
      NULL,
      19.495507,
      20,
      NULL,
      NULL,
      42.028713,
      1.964795,
      NULL,
      ' 4- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


