set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6654708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0130',
      '21401312',
      NULL,
      '21432412',
      '11404344',
      NULL,
      '42113321',
      '21322111',
      '33342212',
      '01230444',
      NULL,
      '40320320',
      '00440220',
      '22304124',
      '22311232',
      '21222030',
      '13204222',
      '42044330',
      '02021211',
      '23433141',
      '41131002',
      '21314402',
      NULL,
      '32001312',
      '22030420',
      '30222331',
      '21410013',
      '40240121',
      '11241431',
      '23314411',
      NULL,
      '31243432',
      '12313114',
      '32201304',
      '22131333',
      '01314210',
      '20004300',
      '21240431',
      '43410301',
      '40030231',
      '30342333',
      '12314111',
      NULL,
      '13033421',
      '03321031',
      '',
      '',
      NULL,
      NULL,
      '0021120',
      0.908942,
      0.424223,
      1,
      NULL,
      '041403',
      2.555935,
      ' 7-29-1978',
      '11-28-1979',
      NULL,
      NULL,
      1.567837,
      26,
      34,
      2,
      45,
      23,
      28,
      NULL,
      2,
      0.952672,
      NULL,
      NULL,
      3.269204,
      13,
      NULL,
      NULL,
      62,
      14.892744,
      2,
      10,
      35,
      NULL,
      NULL,
      116,
      82.272258,
      80.351449,
      121.046892,
      195.086163,
      143.565196,
      ' 1- 3-1994',
      21.178607,
      55.990277,
      6,
      9.852703,
      NULL,
      180,
      ' 8- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1999',
      NULL,
      40.580240,
      116.703719,
      57.788642,
      69,
      NULL,
      50,
      80,
      58,
      NULL,
      127,
      NULL,
      NULL,
      2.119743,
      12,
      30,
      NULL,
      70,
      NULL,
      13,
      ' 0-22-2000',
      16.660591,
      NULL,
      ' 8- 0-1999',
      15,
      NULL,
      14.496724,
      21,
      12.823228,
      19.950713,
      NULL,
      24.623246,
      NULL,
      61.350792,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-27-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69.585446,
      41,
      36,
      '10- 6-1987',
      0,
      1,
      ' 5-19-1975',
      5.285570,
      15.331494,
      21.771510,
      6,
      '11- 0-1984',
      40.622017,
      NULL,
      18.378887,
      ' 8- 2-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      11,
      0,
      NULL,
      21,
      11.293954,
      NULL,
      24.052721,
      0.996982,
      1.368833,
      149,
      NULL,
      5.687344,
      NULL,
      1.057836,
      NULL,
      NULL,
      NULL,
      1,
      0.645896,
      NULL,
      1.161649,
      55.855345,
      48,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.070645,
      NULL,
      1,
      81.675686,
      NULL,
      NULL,
      1,
      35.197974,
      NULL,
      5.261177,
      64.379564,
      17.939623,
      0,
      1,
      NULL,
      0.172550,
      1.687644,
      NULL,
      0,
      NULL,
      NULL,
      ' 5- 8-1988',
      NULL,
      NULL,
      NULL,
      ' 2- 5-1984',
      ' 3- 7-1992',
      NULL);
commit;
end;
/


