set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6654708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0323',
      '02203020',
      '42123122',
      '41110310',
      NULL,
      '44003003',
      '00414002',
      NULL,
      '42424114',
      '40311432',
      '14034130',
      '01143443',
      '20030201',
      NULL,
      '20022131',
      '12410342',
      NULL,
      '40433000',
      '30303342',
      '03123100',
      '11221243',
      '33421023',
      NULL,
      '31011004',
      NULL,
      '23241321',
      '23332421',
      NULL,
      '03024320',
      '20124403',
      '02121304',
      '02300011',
      '33003102',
      '23123441',
      '03323241',
      '44103021',
      '24414240',
      '44014111',
      '34303330',
      '41023002',
      '01432322',
      '44201042',
      '32101114',
      '03434011',
      '30231103',
      NULL,
      '',
      NULL,
      NULL,
      '4023003',
      NULL,
      38.679138,
      3,
      NULL,
      NULL,
      0.341693,
      ' 4-14-2003',
      ' 0-11-1987',
      0,
      NULL,
      50,
      NULL,
      11.854594,
      1.702656,
      NULL,
      18.656119,
      9,
      24,
      2.075338,
      7.993147,
      10,
      16,
      24,
      7.445888,
      NULL,
      8.591406,
      NULL,
      14,
      16.223556,
      4,
      11,
      NULL,
      NULL,
      NULL,
      159.481820,
      70.577737,
      11,
      246.500553,
      NULL,
      ' 2-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.681289,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611997,
      1.420890,
      NULL,
      1.190636,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 8-2000',
      70.727726,
      NULL,
      70,
      77,
      76.841058,
      29.713941,
      25.806948,
      NULL,
      2.938799,
      71,
      131,
      71,
      ' 1-15-1975',
      11.049794,
      6,
      24.352403,
      29,
      NULL,
      137,
      6,
      ' 1-21-2000',
      2.047153,
      22,
      ' 4-25-1998',
      11,
      4.999069,
      NULL,
      3,
      2,
      18,
      NULL,
      6.633420,
      NULL,
      37,
      1,
      3,
      4.878032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.248950,
      54,
      19,
      ' 1-17-1998',
      0.941314,
      29,
      ' 2-13-1986',
      19,
      22,
      15.248242,
      4.243696,
      ' 2-17-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745517,
      0.296337,
      46.365985,
      79,
      29,
      12.189847,
      NULL,
      NULL,
      0,
      7.787229,
      44,
      NULL,
      NULL,
      47,
      0.153803,
      0,
      70.324056,
      3,
      1,
      36,
      NULL,
      0,
      NULL,
      24.763497,
      NULL,
      NULL,
      1,
      70.779704,
      1,
      NULL,
      1,
      1.854765,
      0,
      0.609863,
      5,
      33.010068,
      NULL,
      NULL,
      NULL,
      63.750992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.119625,
      NULL,
      0.554437,
      NULL,
      19,
      NULL,
      9.481836,
      28,
      81.141796,
      NULL,
      NULL,
      1.472133,
      0.661063,
      0,
      1.269749,
      1.379103,
      1,
      1.520237,
      NULL,
      73,
      ' 4- 7-1992',
      NULL,
      NULL,
      NULL,
      ' 6-11-1984',
      NULL,
      NULL,
      NULL);
commit;
end;
/


