set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6654708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4122',
      '33232003',
      NULL,
      '13220430',
      '22142302',
      '13300300',
      NULL,
      '03334321',
      '01000340',
      NULL,
      '24131042',
      '22422103',
      '11322423',
      '30211232',
      '11310214',
      '43303232',
      '30210043',
      '01334230',
      '32104224',
      '20000030',
      '10101341',
      '12401311',
      '20033432',
      '10243444',
      '41332232',
      '02210223',
      NULL,
      '02144140',
      '24001111',
      '41232313',
      '02142234',
      '01314440',
      '44320004',
      '34341340',
      '43001443',
      '11343334',
      '13142231',
      NULL,
      '04443211',
      NULL,
      '32111311',
      '20433011',
      NULL,
      '40224322',
      '23421041',
      '024',
      '43',
      NULL,
      NULL,
      '4133043',
      0,
      31.828402,
      1,
      NULL,
      '322143',
      1,
      '10-15-1979',
      NULL,
      NULL,
      NULL,
      5.841908,
      0.639695,
      21,
      10,
      NULL,
      16.391045,
      NULL,
      5,
      25.716866,
      NULL,
      51.976354,
      NULL,
      2,
      3.662168,
      30,
      27.138772,
      45.883468,
      8.025104,
      35,
      6.804891,
      107.216141,
      19.725726,
      1,
      49.660596,
      40,
      14.844782,
      262,
      179.403033,
      149.510200,
      ' 2-29-2002',
      18,
      2,
      22,
      18.868218,
      56,
      240,
      '11- 5-1991',
      1.459720,
      0.812683,
      NULL,
      0.753997,
      NULL,
      NULL,
      1,
      0.371642,
      0.637918,
      1.552088,
      1,
      1,
      0.716371,
      1,
      0.412558,
      1,
      0,
      0.591751,
      1.839287,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1977',
      49.240266,
      5,
      16.531876,
      0.628544,
      15,
      5,
      ' 9-18-1990',
      NULL,
      0.049268,
      212.322760,
      1,
      0.235545,
      25,
      1.905568,
      0.533116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      59,
      20.916794,
      NULL,
      NULL,
      NULL,
      23.531334,
      10.380140,
      37,
      30.380150,
      74,
      ' 3-19-1987',
      NULL,
      1,
      11.946097,
      5,
      28.606792,
      143.612489,
      1.203006,
      ' 0-26-1983',
      18.584948,
      18,
      ' 8-26-1995',
      NULL,
      NULL,
      14,
      4,
      0.384022,
      1,
      0,
      16.916085,
      1,
      NULL,
      1.705910,
      0.658480,
      14.733886,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      203.164277,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      14.070556,
      ' 6- 9-1977',
      25,
      ' 1-28-1978',
      6,
      11,
      ' 7-14-1992',
      98.548811,
      128,
      ' 1-29-1981',
      3,
      5,
      ' 7-10-1990',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      17,
      '11-22-1995',
      69,
      56,
      45,
      ' 5- 4-2002',
      0.651984,
      NULL,
      ' 4-28-2002',
      11,
      24,
      6.134044,
      23.457597,
      '11-14-1991',
      48,
      1.608591,
      33.903578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


