set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6654708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      '3',
      '2',
      '3',
      '2',
      '3',
      '0',
      '3',
      '0',
      NULL,
      '3',
      '2',
      '1',
      '4',
      '4',
      '0',
      '3',
      '0',
      NULL,
      '4',
      '4',
      '4',
      '',
      '3',
      '',
      '0',
      NULL,
      '2',
      '4',
      '3',
      '',
      '',
      '1',
      '1',
      '0',
      '4',
      NULL,
      '2',
      '2',
      NULL,
      '2',
      '2',
      '4',
      NULL,
      '12010313',
      41.275493,
      66.387706,
      '1204001',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203318,
      ' 9-15-1996',
      ' 7-18-1980',
      25.179364,
      64,
      35,
      NULL,
      39,
      2.763729,
      116,
      NULL,
      NULL,
      23.953435,
      4,
      5.599462,
      29,
      2.081736,
      3,
      1,
      5,
      17.695515,
      0,
      0,
      53.377639,
      21.930943,
      107.768574,
      NULL,
      1.251404,
      90.966568,
      107.977162,
      NULL,
      222.824205,
      53,
      241,
      '10- 2-1983',
      NULL,
      5.063707,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-24-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      5,
      7,
      2.341389,
      6.460817,
      1.430395,
      ' 7-26-1998',
      NULL,
      0.829594,
      116,
      0,
      1,
      NULL,
      1.949076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 4-1975',
      NULL,
      1,
      112.164627,
      51,
      77.876033,
      98.506024,
      25,
      111,
      41,
      13,
      105,
      18.883424,
      ' 3-27-1996',
      NULL,
      29.187815,
      19,
      47,
      30.026907,
      NULL,
      10.637448,
      ' 7-25-1990',
      2,
      10.995322,
      NULL,
      16,
      6.369392,
      29.683468,
      11.894354,
      2,
      7,
      1.441490,
      20,
      1.365530,
      120.875009,
      1,
      1,
      12.832656,
      12.111620,
      0.789244,
      0,
      NULL,
      1.426431,
      ' 0-26-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.318511,
      ' 3-27-1976',
      NULL,
      NULL,
      NULL,
      58.513941,
      ' 0-23-2001',
      NULL,
      '10-10-1980',
      NULL,
      NULL,
      ' 9- 9-1977',
      96.951485,
      20,
      ' 4-12-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      24,
      ' 5- 7-1983',
      47,
      23.961633,
      15,
      ' 9- 3-1999',
      0.170331,
      18.170481,
      ' 9- 2-2000',
      16,
      17.456907,
      21.738230,
      NULL,
      '11-12-1976',
      47.723746,
      0.829738,
      NULL,
      '11-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


