set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6654708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      '3',
      '4',
      '1',
      '4',
      '0',
      NULL,
      '2',
      '0',
      '2',
      '1',
      NULL,
      '3',
      '0',
      '4',
      '4',
      '2',
      '0',
      '0',
      '0',
      '1',
      '1',
      '0',
      '',
      '2',
      '',
      NULL,
      '1',
      '2',
      NULL,
      '3',
      '',
      '',
      '0',
      '2',
      '2',
      '0',
      '4',
      '2',
      NULL,
      '3',
      '4',
      '0',
      '0',
      '404',
      '23002224',
      43.886527,
      35.372239,
      '4002114',
      2.100515,
      359,
      2,
      0,
      NULL,
      4,
      NULL,
      ' 3- 2-1977',
      80.764893,
      168,
      49.002771,
      22,
      29,
      12.051659,
      65.899023,
      10.411697,
      22,
      16,
      33.236472,
      3.693835,
      18,
      3.227866,
      33,
      23,
      8,
      12,
      10.525489,
      21,
      55,
      25,
      NULL,
      1,
      0.932169,
      NULL,
      177,
      95,
      1.698988,
      79,
      239,
      ' 1-26-1991',
      67.948492,
      10.743085,
      0.259927,
      NULL,
      167.345941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.889715,
      1,
      12.455854,
      3,
      7,
      NULL,
      '10-24-1981',
      0,
      0.328512,
      46,
      0.292183,
      1,
      91,
      1.150928,
      1,
      17.678442,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1979',
      55.891980,
      90,
      20.155908,
      32,
      40.610665,
      82.797686,
      43,
      23.309855,
      76.106195,
      NULL,
      74.488221,
      84.281362,
      ' 6- 7-1991',
      20.022852,
      30.809954,
      39.093504,
      71,
      20,
      192.613988,
      NULL,
      '10-13-1987',
      4.251172,
      NULL,
      NULL,
      8.336684,
      3,
      0,
      2.035928,
      0,
      1.530783,
      0.966937,
      0,
      1,
      103.777201,
      0,
      NULL,
      31.803745,
      1,
      1.336549,
      1.481029,
      NULL,
      NULL,
      ' 9- 4-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      242,
      1.228670,
      ' 5-13-1977',
      NULL,
      NULL,
      NULL,
      19,
      '10- 0-1991',
      32.792992,
      NULL,
      3,
      4,
      NULL,
      0.619426,
      NULL,
      ' 6-24-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 5-21-1977',
      NULL,
      NULL,
      6,
      ' 6-24-1998',
      0.365414,
      20.844656,
      ' 2-26-1986',
      8.187305,
      4,
      NULL,
      13.622268,
      NULL,
      23.410834,
      0.112123,
      9,
      '11-12-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


