set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433307';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0022',
      '24210144',
      NULL,
      '33031122',
      NULL,
      NULL,
      '30242042',
      '01243132',
      NULL,
      '41433302',
      NULL,
      '31234344',
      '31121430',
      '44314123',
      '33344034',
      '44112132',
      '32010303',
      '00220424',
      '11102330',
      NULL,
      '30031000',
      '23402444',
      '33122102',
      '21310232',
      '03414304',
      '03110000',
      '44124020',
      NULL,
      '34413402',
      '14321042',
      '02232011',
      NULL,
      '02141031',
      '12004104',
      '34120304',
      '04110013',
      '33203430',
      '34342123',
      '01320404',
      '34444432',
      '20020033',
      '40331331',
      '11114344',
      '31212430',
      '44334121',
      '123',
      '11',
      NULL,
      NULL,
      NULL,
      3.562163,
      0,
      1,
      NULL,
      NULL,
      0,
      ' 4-29-1974',
      ' 8-13-1976',
      NULL,
      NULL,
      37,
      10.689358,
      7,
      7.455492,
      91,
      3.214005,
      8.072901,
      22,
      0.646928,
      8.337040,
      7,
      17.844144,
      3.092848,
      14,
      39.674590,
      NULL,
      51.641530,
      13.405988,
      NULL,
      NULL,
      46.267015,
      3,
      0,
      NULL,
      28,
      16,
      201,
      102,
      92.156058,
      ' 7- 0-1995',
      NULL,
      64.913428,
      14,
      6.920296,
      193.806239,
      9.285533,
      '10-19-1985',
      2,
      1.752200,
      0.416581,
      0,
      NULL,
      2,
      0.105784,
      0,
      NULL,
      1,
      2.056481,
      NULL,
      0.066780,
      1.851764,
      1.903471,
      1,
      3.629964,
      0,
      1,
      0.962755,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-15-2000',
      45,
      2.331390,
      7.568517,
      9.165916,
      3,
      1.350812,
      ' 4-20-1975',
      NULL,
      0,
      122.064066,
      1.646629,
      1,
      10,
      1.259839,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      8,
      37.693705,
      NULL,
      122.245845,
      61.392440,
      114.907324,
      NULL,
      48,
      65,
      83,
      ' 9- 4-1991',
      39.484653,
      NULL,
      23.819387,
      15,
      NULL,
      50,
      14,
      ' 5-21-1975',
      7.527483,
      15.217104,
      ' 5-22-1995',
      NULL,
      6,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      20.191935,
      NULL,
      13.660436,
      1,
      0,
      17.434485,
      5.413773,
      1,
      0.094934,
      0.320629,
      0.965019,
      '11-12-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      148.370255,
      0.056123,
      ' 1-27-1997',
      NULL,
      NULL,
      NULL,
      3.681374,
      NULL,
      49.635437,
      ' 7-29-1975',
      5.023909,
      19.382558,
      ' 3-26-1985',
      45.624673,
      63,
      ' 0-29-1981',
      9,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.803350,
      ' 7-11-1988',
      70.139649,
      NULL,
      41.804682,
      ' 3- 5-1988',
      0,
      23,
      ' 3-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


