set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7326903';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      '0',
      '4',
      '1',
      '4',
      '0',
      '4',
      '2',
      NULL,
      '0',
      '3',
      '0',
      NULL,
      '0',
      '0',
      NULL,
      '1',
      '3',
      NULL,
      '2',
      '3',
      '2',
      '',
      '1',
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      '3',
      '',
      '',
      '1',
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      26,
      17,
      '2134331',
      1.523931,
      0,
      1,
      NULL,
      NULL,
      4,
      ' 5-15-1982',
      ' 8-13-1996',
      137.219695,
      NULL,
      20,
      24.883927,
      NULL,
      NULL,
      66.622129,
      NULL,
      23.043898,
      23.358262,
      19,
      6,
      1,
      19,
      3,
      17.039008,
      NULL,
      7.315294,
      NULL,
      NULL,
      52.955087,
      NULL,
      11.705214,
      9.940883,
      1.089442,
      152,
      240.666844,
      76.238928,
      21.125454,
      9,
      51,
      NULL,
      24.489307,
      29,
      17.695058,
      11.818644,
      77,
      104.704567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37.258645,
      NULL,
      5.276677,
      2.654532,
      NULL,
      8,
      ' 3-29-1976',
      1,
      0,
      71,
      NULL,
      0,
      48.623142,
      1.935416,
      0.795091,
      7.425436,
      NULL,
      NULL,
      NULL,
      NULL,
      110,
      19,
      10.935246,
      50,
      NULL,
      87.224175,
      54,
      NULL,
      87,
      NULL,
      31.543670,
      72,
      ' 5-22-2002',
      NULL,
      1,
      NULL,
      NULL,
      17,
      17.767472,
      4,
      '11-14-1984',
      0,
      16,
      '10- 4-1988',
      0.671680,
      9,
      16,
      19,
      15.439795,
      1.743712,
      0,
      12.905383,
      0.663923,
      29.232876,
      2,
      0,
      NULL,
      27,
      NULL,
      1,
      1.665150,
      2.288556,
      ' 4-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      173,
      8,
      '10-28-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      ' 6-29-2000',
      13,
      6,
      '11- 1-1992',
      100,
      102.958774,
      ' 1- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      22.374607,
      '11-23-1993',
      38,
      NULL,
      2.973118,
      ' 4- 3-2003',
      0.775839,
      72,
      ' 0- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


