set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8827414';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41023203',
      NULL,
      '24303434',
      '00201421',
      '31402402',
      '42003040',
      NULL,
      '24404044',
      '11404143',
      '04313020',
      '30040444',
      '30432014',
      '20203121',
      '33024204',
      '34021201',
      '40330020',
      '41102020',
      '01113200',
      '32200020',
      '43144310',
      NULL,
      '01404243',
      NULL,
      NULL,
      '14444403',
      NULL,
      '14342442',
      '01412014',
      '04034132',
      '10400231',
      '10102410',
      '31002014',
      '43104242',
      '40002230',
      NULL,
      '23123131',
      '30303241',
      NULL,
      '04411032',
      NULL,
      '02420420',
      '01131013',
      '13404230',
      '11232004',
      NULL,
      '',
      NULL,
      NULL,
      '4110214',
      3,
      1.465102,
      1,
      NULL,
      '300441',
      2.396383,
      ' 0-22-1991',
      ' 2-28-1979',
      26,
      NULL,
      20.839589,
      NULL,
      22,
      13.588800,
      43,
      15,
      NULL,
      22,
      18.558327,
      3.955559,
      27,
      14,
      28.166817,
      18.589062,
      2.158288,
      NULL,
      NULL,
      1,
      35,
      NULL,
      55.481605,
      26,
      NULL,
      87.317305,
      240,
      13,
      203.569467,
      229,
      73,
      ' 7- 0-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      143.834636,
      NULL,
      2.418562,
      NULL,
      1.527733,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948979,
      0,
      NULL,
      NULL,
      1.970913,
      1.230807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      16.426423,
      NULL,
      33.062286,
      55.737728,
      114,
      NULL,
      98,
      122,
      NULL,
      NULL,
      NULL,
      '11-17-1989',
      39,
      30,
      11,
      117,
      49.601011,
      NULL,
      NULL,
      ' 0-19-1975',
      30,
      0,
      ' 6-20-1991',
      15,
      21.480346,
      27,
      20,
      31,
      14.918088,
      NULL,
      2,
      NULL,
      121,
      0.171683,
      1.365059,
      9.402174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      7.916873,
      13.863789,
      NULL,
      1,
      NULL,
      '11-22-1997',
      14.412925,
      4.402123,
      20.043825,
      13,
      ' 8-14-1989',
      NULL,
      NULL,
      155,
      '10-25-1996',
      NULL,
      NULL,
      NULL,
      66.424326,
      0,
      1.502597,
      46.352606,
      117,
      135.143929,
      0,
      5.979012,
      2,
      8.743087,
      3.541704,
      31.832102,
      1.485903,
      1,
      22,
      1,
      NULL,
      NULL,
      1.294092,
      0,
      31.657657,
      2.397028,
      1.395665,
      12,
      144,
      NULL,
      82.153934,
      1,
      80.309736,
      0,
      0.380611,
      1.722718,
      0,
      0,
      0,
      121.273345,
      109.033836,
      NULL,
      NULL,
      149.923705,
      62.168841,
      0,
      NULL,
      45.928981,
      0.275076,
      1.032063,
      29,
      NULL,
      0.808364,
      34,
      0.079571,
      79,
      1.394576,
      1.274633,
      24.010183,
      19,
      NULL,
      32.664839,
      104.322330,
      24.668479,
      NULL,
      64.223770,
      5,
      0,
      1.225833,
      NULL,
      NULL,
      0.819688,
      1,
      0.186982,
      NULL,
      NULL,
      ' 9- 9-2000',
      NULL,
      ' 2-15-2001',
      '10-22-1990',
      ' 4- 0-1975',
      NULL,
      NULL);
commit;
end;
/


