set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7925101';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4024',
      '12342233',
      '11401334',
      '04424340',
      '44320022',
      '10333004',
      '04323204',
      '11420321',
      '03210240',
      NULL,
      '21232333',
      '32410044',
      '01320130',
      '03122412',
      '24003304',
      '02012000',
      '20221124',
      '24044421',
      '01043231',
      '42043221',
      '14324032',
      '44000022',
      NULL,
      '43312242',
      '32221033',
      '23344311',
      '13001141',
      '20311010',
      '04432314',
      NULL,
      NULL,
      '21041144',
      NULL,
      '03323340',
      '32202233',
      '30033142',
      '13112310',
      '02200344',
      '13032301',
      '21434400',
      '12314231',
      '12134121',
      NULL,
      NULL,
      '34132124',
      '012',
      '44',
      30,
      12,
      NULL,
      1,
      NULL,
      3,
      NULL,
      '220103',
      5.014955,
      ' 7-25-1983',
      ' 8- 0-1979',
      84.001749,
      11,
      NULL,
      2.543572,
      7,
      12,
      57.162929,
      4.239675,
      8,
      5,
      18.370025,
      NULL,
      3,
      NULL,
      20.368225,
      6.167023,
      9,
      13,
      28,
      0,
      7.784645,
      11.442518,
      110,
      11.706550,
      0,
      82.024551,
      97,
      NULL,
      NULL,
      35.664368,
      102,
      ' 3- 6-1987',
      29.353669,
      3.826085,
      8.719862,
      NULL,
      NULL,
      23,
      '10-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      13,
      1,
      0.503513,
      116,
      13.798434,
      7,
      64,
      NULL,
      NULL,
      NULL,
      '11-19-2000',
      35,
      36.705642,
      NULL,
      45.732087,
      8,
      67.134177,
      64.876642,
      15.005665,
      NULL,
      27,
      NULL,
      68,
      ' 0-16-2003',
      2,
      4,
      11.715156,
      49,
      25.979648,
      85.000690,
      1,
      ' 2- 8-1978',
      6,
      0.178842,
      NULL,
      7,
      19,
      NULL,
      NULL,
      16.015206,
      NULL,
      1,
      NULL,
      NULL,
      111,
      1,
      3,
      12,
      8,
      8,
      3,
      2,
      NULL,
      ' 7-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      ' 3- 5-1977',
      NULL,
      '11-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      24.583064,
      18.020626,
      '11-22-1995',
      3,
      140.655493,
      ' 8- 2-2003',
      0.786825,
      55,
      NULL,
      NULL,
      ' 3-16-1974',
      50,
      0,
      136.397235,
      '11-18-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


