set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7925101';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '0',
      NULL,
      '2',
      NULL,
      '4',
      NULL,
      NULL,
      '0',
      '0',
      '0',
      NULL,
      '1',
      '1',
      '4',
      NULL,
      '3',
      '3',
      '3',
      '4',
      '3',
      NULL,
      '0',
      '',
      '1',
      '',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '',
      '',
      '3',
      '4',
      '0',
      '2',
      '0',
      '2',
      '1',
      '4',
      '3',
      '1',
      NULL,
      '133',
      '12212112',
      45.883004,
      1.082339,
      '1042113',
      0,
      49.422797,
      1,
      NULL,
      '310202',
      0,
      ' 7-21-1974',
      ' 5-23-1997',
      77,
      163.957431,
      6.397738,
      15.472079,
      NULL,
      17.846158,
      21.131295,
      8.162594,
      6.995589,
      5,
      9.648688,
      4.970277,
      16,
      7.971817,
      0.420644,
      8,
      4.808190,
      6.392629,
      17.843676,
      5,
      NULL,
      3,
      101,
      NULL,
      1.337559,
      15.749070,
      72.663269,
      72.047922,
      145.265367,
      NULL,
      164.692353,
      ' 1-21-1977',
      34.125340,
      20.252742,
      22,
      12.487917,
      111,
      156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65.435309,
      36.432270,
      NULL,
      32,
      10.118063,
      NULL,
      ' 7-24-2000',
      5.588504,
      0,
      205,
      15.109443,
      NULL,
      45,
      10.780446,
      6.794806,
      12,
      NULL,
      NULL,
      NULL,
      ' 0- 2-1992',
      40,
      68.573631,
      49,
      47,
      NULL,
      24.503708,
      88,
      66,
      64.279585,
      47,
      56,
      62,
      ' 0- 9-2003',
      20.828335,
      11.918221,
      24,
      52,
      93.903319,
      NULL,
      5.663935,
      ' 4- 1-1980',
      27.287403,
      6,
      ' 1-16-2000',
      4,
      5,
      NULL,
      NULL,
      18,
      2.744555,
      0,
      5.646968,
      1.376003,
      0.363516,
      NULL,
      0.422544,
      21.269934,
      NULL,
      0.208714,
      0.629814,
      NULL,
      1.753545,
      ' 3- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.171870,
      NULL,
      9.834204,
      NULL,
      9.822397,
      2.847150,
      ' 9- 4-1983',
      NULL,
      49.988720,
      ' 0- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      ' 6- 8-1980',
      3,
      10.960551,
      ' 3- 3-1992',
      0,
      42.900297,
      NULL,
      NULL,
      ' 0-11-1980',
      36.075863,
      1.056670,
      NULL,
      ' 1- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


