set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8831502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3233',
      '41433033',
      NULL,
      '32123232',
      '21322322',
      NULL,
      NULL,
      NULL,
      '34211242',
      '23310111',
      '03143042',
      '00221300',
      NULL,
      '31223302',
      NULL,
      '14434133',
      '31313321',
      '13302410',
      '22342312',
      '23333312',
      '21310320',
      '11404131',
      '22111024',
      '40032342',
      '30424002',
      '30003402',
      '03320222',
      '01033300',
      NULL,
      NULL,
      '32220320',
      NULL,
      '44112113',
      '04143204',
      '12004313',
      '01042440',
      '31100030',
      NULL,
      '34224323',
      '04433134',
      NULL,
      NULL,
      NULL,
      '42240012',
      NULL,
      NULL,
      '32',
      NULL,
      NULL,
      '0330111',
      0,
      NULL,
      1,
      NULL,
      NULL,
      5,
      ' 0-16-1998',
      ' 2- 4-1979',
      37,
      NULL,
      44,
      9.248954,
      0.954867,
      9,
      42,
      10.284678,
      3,
      12.475495,
      NULL,
      NULL,
      49.173131,
      17,
      9,
      3.296168,
      12,
      21,
      NULL,
      NULL,
      55,
      4.127832,
      94.351793,
      9,
      0.715959,
      140,
      NULL,
      NULL,
      172.424344,
      228,
      33,
      NULL,
      69.492947,
      34.475197,
      23.386729,
      NULL,
      16.303166,
      36.041923,
      '10-28-1978',
      1,
      2,
      1.694268,
      1,
      1.965650,
      0.861297,
      1.210555,
      NULL,
      0.728053,
      0.918019,
      NULL,
      0.559076,
      0,
      0.196355,
      0.991092,
      0,
      NULL,
      NULL,
      1,
      1.790154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.144710,
      NULL,
      NULL,
      NULL,
      NULL,
      8.381723,
      ' 3-18-2000',
      1.383770,
      0,
      42.955313,
      1,
      0.680832,
      85,
      NULL,
      1,
      63,
      NULL,
      NULL,
      NULL,
      '10-15-2003',
      NULL,
      48.475628,
      101,
      43.088852,
      112.308808,
      98.283749,
      NULL,
      0,
      85.305243,
      48,
      14.411533,
      4.773909,
      NULL,
      NULL,
      11.109661,
      22,
      70.898510,
      NULL,
      122,
      3,
      ' 9-26-1978',
      10.093130,
      NULL,
      ' 3-25-1996',
      5.034733,
      6.189762,
      13,
      27.843594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.689892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1989',
      2.183301,
      NULL,
      NULL,
      NULL,
      45,
      1.066339,
      ' 1-21-1983',
      35.236757,
      5.415960,
      ' 1-14-1997',
      28,
      ' 2-26-1979',
      15.538171,
      ' 7-12-1989',
      NULL,
      4,
      NULL,
      NULL,
      66.673545,
      ' 6-25-1990',
      1,
      NULL,
      ' 8-21-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      10,
      ' 3- 7-1994',
      23,
      34,
      4.977670,
      '11- 7-1984',
      0,
      20,
      ' 8-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


