set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8831502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40223322',
      '02432134',
      '14210112',
      '31323041',
      '13243002',
      '10413240',
      '23321241',
      '42300402',
      '03244114',
      NULL,
      '20444311',
      '11420444',
      '30442411',
      NULL,
      '01010333',
      '30011301',
      '30414332',
      NULL,
      '22101112',
      '22032341',
      '41331101',
      '42033223',
      NULL,
      '42133131',
      '30241321',
      '00444042',
      '11443230',
      NULL,
      '32012031',
      '14320113',
      '00103213',
      '24140122',
      '03010413',
      '21110402',
      '11302140',
      NULL,
      '14412212',
      '41114232',
      '40034241',
      '24401120',
      '32313313',
      '40340430',
      NULL,
      '20141100',
      '111',
      NULL,
      NULL,
      NULL,
      '1413341',
      NULL,
      31,
      0,
      NULL,
      '203210',
      NULL,
      ' 0-25-1989',
      ' 6-22-1982',
      101.275590,
      NULL,
      NULL,
      3,
      43,
      13,
      119,
      6.339083,
      35.036922,
      NULL,
      17,
      7,
      38.278649,
      2.916785,
      25.748802,
      7,
      NULL,
      8,
      31.283016,
      1.241473,
      23,
      6,
      81.977442,
      NULL,
      0.137745,
      47,
      51,
      NULL,
      13,
      271,
      137,
      ' 5-16-1995',
      50.282074,
      NULL,
      15.284256,
      31,
      41.944477,
      NULL,
      ' 0-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      NULL,
      NULL,
      11,
      5.271632,
      5.564946,
      '11-19-1996',
      1,
      NULL,
      78.644791,
      0.475518,
      0,
      126.319839,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1995',
      41.844719,
      43,
      83.762124,
      65.941725,
      98,
      NULL,
      24,
      NULL,
      10.580993,
      103,
      67.050948,
      NULL,
      ' 6- 6-1984',
      NULL,
      NULL,
      16.509468,
      10,
      23,
      NULL,
      11,
      NULL,
      24,
      36.072216,
      ' 1-19-1993',
      NULL,
      1.619812,
      12.375681,
      NULL,
      10,
      12.481373,
      0,
      13.701747,
      0,
      115,
      0.542997,
      1,
      17,
      0,
      0,
      NULL,
      0.867710,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      107.428853,
      0.308321,
      ' 4-10-1974',
      NULL,
      NULL,
      NULL,
      39.098731,
      NULL,
      28,
      ' 2-21-1976',
      3.928975,
      12,
      ' 2-23-1979',
      40,
      62.753549,
      ' 7-13-1985',
      0,
      2.590592,
      '10-10-1991',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      21,
      ' 7-21-1980',
      11.425550,
      27.267243,
      10.380680,
      NULL,
      NULL,
      NULL,
      ' 2-24-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


