set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616534';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3404',
      '20041420',
      NULL,
      NULL,
      '13243440',
      '42312121',
      NULL,
      '01431114',
      '11132232',
      NULL,
      '02422211',
      '11112442',
      NULL,
      '30141142',
      '12214340',
      '33004244',
      '34203112',
      NULL,
      '41403344',
      '21031242',
      NULL,
      '42402213',
      NULL,
      '04121444',
      '20233123',
      NULL,
      '22332212',
      NULL,
      '10430010',
      '33023143',
      '04314000',
      '22011202',
      '33101421',
      NULL,
      NULL,
      '20033323',
      '33243433',
      '10034210',
      '31320241',
      '02103402',
      '03002023',
      NULL,
      '11241420',
      '32244214',
      '01422021',
      '304',
      '03',
      NULL,
      NULL,
      NULL,
      0.606789,
      0.600880,
      3,
      NULL,
      '434413',
      2.742554,
      ' 3- 4-1986',
      ' 0-26-1983',
      NULL,
      NULL,
      36,
      7,
      2,
      NULL,
      1.962432,
      3,
      13,
      11,
      25.434907,
      NULL,
      33.399171,
      19,
      7,
      NULL,
      NULL,
      15.094395,
      8,
      NULL,
      16.742914,
      NULL,
      69.209141,
      18.228066,
      NULL,
      95,
      NULL,
      63,
      NULL,
      148.232983,
      159,
      NULL,
      41.648579,
      NULL,
      0.387664,
      NULL,
      29,
      168.567398,
      NULL,
      2,
      2,
      1,
      1.077858,
      1.878139,
      NULL,
      0.323865,
      0.347715,
      1.275409,
      0.881997,
      1,
      0.724403,
      1.603959,
      1,
      0.871217,
      1.358676,
      0,
      0,
      1.064542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1986',
      48.474808,
      3.001954,
      9.016074,
      NULL,
      11.387611,
      0,
      ' 7- 8-1976',
      1,
      NULL,
      162.841614,
      1,
      NULL,
      67,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-12-1978',
      NULL,
      12.862880,
      18,
      71,
      107.823812,
      65,
      26,
      NULL,
      14.957092,
      79.536559,
      14.225237,
      NULL,
      ' 0-14-1999',
      9.259377,
      22,
      24,
      78,
      77,
      128,
      6.338721,
      '10- 6-1983',
      4.610558,
      2,
      ' 4-15-1987',
      11.168560,
      NULL,
      1,
      18,
      16,
      4.974357,
      1.707144,
      8.962048,
      0,
      21,
      0,
      4,
      NULL,
      11,
      NULL,
      9.984972,
      1.999903,
      3.227390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      17,
      ' 2- 4-1996',
      NULL,
      NULL,
      NULL,
      12.324540,
      ' 1-22-1999',
      NULL,
      ' 7-25-1977',
      7.066199,
      4,
      '10-20-1979',
      70,
      27,
      NULL,
      8.793935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      15.762738,
      ' 0-25-1985',
      NULL,
      59,
      58,
      ' 9-24-2002',
      NULL,
      29,
      ' 6-12-2002',
      14.182136,
      23,
      19.760807,
      NULL,
      ' 7-24-1983',
      69.319539,
      1.657291,
      54,
      ' 2- 4-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


