set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8837085';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      '1',
      '3',
      '0',
      '4',
      NULL,
      '3',
      '2',
      NULL,
      '3',
      '3',
      '4',
      NULL,
      '2',
      '4',
      '1',
      '0',
      '2',
      NULL,
      '0',
      NULL,
      '4',
      '',
      '2',
      '',
      '2',
      NULL,
      '1',
      '4',
      '3',
      '',
      '',
      NULL,
      '4',
      '3',
      '3',
      '2',
      '0',
      '4',
      '0',
      '2',
      NULL,
      '0',
      NULL,
      '20100012',
      NULL,
      26,
      '3312430',
      3,
      1.164405,
      2,
      0,
      '411211',
      NULL,
      NULL,
      ' 4-25-1990',
      105.159198,
      295,
      11.580312,
      6.886329,
      NULL,
      NULL,
      21.700545,
      13.275982,
      14,
      4,
      NULL,
      5,
      45.955402,
      NULL,
      11.722796,
      17,
      8.891859,
      14.356359,
      NULL,
      1,
      31.863226,
      NULL,
      88.387238,
      NULL,
      1.832529,
      NULL,
      NULL,
      9.266258,
      NULL,
      NULL,
      141,
      ' 2-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85.821026,
      0,
      7.263675,
      6,
      5,
      6.000598,
      ' 2- 7-2003',
      0,
      0,
      132.741919,
      1.208281,
      1,
      68,
      2.281568,
      0.585824,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      25,
      54,
      76.678141,
      47.909731,
      96.388077,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      ' 0-28-1998',
      NULL,
      27,
      7.304606,
      37,
      85,
      114.461629,
      NULL,
      '11-22-2003',
      9.061135,
      5,
      '10-28-1978',
      13,
      18,
      4,
      18.367737,
      13.800700,
      3.699362,
      NULL,
      17,
      1.277080,
      29,
      NULL,
      1.908116,
      12,
      14,
      1.339998,
      0.833763,
      1,
      0,
      '10- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      171,
      17.712715,
      ' 2-20-1989',
      NULL,
      NULL,
      NULL,
      18.099717,
      ' 4-12-1993',
      43,
      ' 1-28-2001',
      11.425557,
      3,
      ' 6-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      4,
      ' 8-15-1992',
      9.003436,
      14,
      14,
      ' 9-14-1977',
      1.670632,
      NULL,
      ' 5-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


