set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9322738';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23200021',
      NULL,
      '24010222',
      '42111434',
      '44113341',
      '13213132',
      '01420433',
      NULL,
      NULL,
      '02220224',
      NULL,
      '02303420',
      '41331412',
      '40223144',
      '42421413',
      '13122431',
      '42121433',
      NULL,
      '43312444',
      NULL,
      '11012334',
      '44031001',
      NULL,
      '14334133',
      '20123300',
      '11302224',
      '01242110',
      '14403022',
      '04040013',
      '20414332',
      NULL,
      '32400410',
      '33241441',
      '44433324',
      NULL,
      NULL,
      '24034344',
      '30133011',
      NULL,
      '24243330',
      '02413100',
      '02213113',
      '13320121',
      NULL,
      '210',
      '23',
      NULL,
      NULL,
      '4220304',
      NULL,
      1,
      1,
      NULL,
      '042213',
      NULL,
      ' 4-21-2001',
      ' 6-28-1993',
      32,
      NULL,
      32.447694,
      9,
      3,
      12,
      NULL,
      8.861387,
      3,
      19.534905,
      28.253722,
      NULL,
      29,
      4.806604,
      26.928049,
      14.957840,
      18.274903,
      4,
      47.457582,
      12,
      32.946205,
      26.239572,
      93,
      20.922353,
      0,
      46,
      57,
      71.068942,
      NULL,
      135,
      NULL,
      ' 5-25-1977',
      7.943736,
      NULL,
      0,
      34,
      124.509204,
      177,
      ' 8-20-1998',
      NULL,
      1.332643,
      2,
      1,
      0.083634,
      0,
      NULL,
      0.899061,
      0.100208,
      1,
      0,
      NULL,
      0.625137,
      NULL,
      0,
      0.331007,
      1.304031,
      0.078400,
      0.714171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1980',
      89.106236,
      21,
      NULL,
      NULL,
      7,
      7,
      ' 8-13-1979',
      0.740947,
      1,
      115.308624,
      0.061594,
      NULL,
      12.848199,
      0.176301,
      1,
      24.271362,
      NULL,
      NULL,
      NULL,
      ' 2-11-1981',
      93,
      79.322853,
      118.370761,
      NULL,
      NULL,
      45.362773,
      67,
      97,
      64,
      38,
      NULL,
      NULL,
      NULL,
      23,
      14,
      NULL,
      34.403625,
      NULL,
      NULL,
      10.557197,
      ' 0- 5-1990',
      9.070137,
      11.438747,
      NULL,
      NULL,
      8,
      10.762416,
      21.383789,
      9,
      5,
      0.382931,
      9.806746,
      1.651489,
      21,
      1.603909,
      0.264419,
      NULL,
      7.398770,
      2.506825,
      1,
      NULL,
      1,
      ' 3-14-1989',
      5,
      3.540997,
      0,
      ' 4- 3-1983',
      46.979300,
      1.577357,
      ' 8-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.717287,
      ' 9- 3-1999',
      4.855129,
      0.242089,
      ' 8- 9-1978',
      92.607883,
      8.610826,
      NULL,
      5.088362,
      5,
      ' 7-14-2001',
      NULL,
      NULL,
      NULL,
      2,
      0,
      17.487868,
      ' 1-23-2003',
      16,
      20.528046,
      51.273258,
      ' 9-29-1998',
      NULL,
      145,
      ' 1-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17);
commit;
end;
/


