set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9132232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4314',
      '41230420',
      '41400212',
      NULL,
      NULL,
      '13034241',
      '13123021',
      '04123022',
      '00031340',
      '12111140',
      '43040442',
      '20103441',
      NULL,
      '10323001',
      NULL,
      '14220210',
      '21021243',
      '42113044',
      '11424122',
      '21213234',
      NULL,
      '30440123',
      '41320424',
      NULL,
      '20012423',
      '40331440',
      '02041133',
      '14200202',
      NULL,
      '31320140',
      NULL,
      NULL,
      '01440231',
      '32310103',
      '31211340',
      '10124414',
      '10010134',
      '43302002',
      NULL,
      '40312241',
      '00200422',
      NULL,
      '21222140',
      NULL,
      '33333104',
      '404',
      '14',
      NULL,
      NULL,
      '3334331',
      3.133939,
      0.612921,
      2,
      NULL,
      '323134',
      5,
      '10-13-1978',
      ' 2- 0-1986',
      4.377423,
      NULL,
      29.309644,
      16.340402,
      3,
      10,
      70,
      20,
      14.714638,
      NULL,
      15,
      22.408240,
      30,
      10.118237,
      29,
      4.950988,
      2,
      18.872795,
      64,
      NULL,
      31.126897,
      14,
      NULL,
      NULL,
      NULL,
      7.730036,
      NULL,
      135,
      NULL,
      281.435649,
      219.699371,
      NULL,
      31,
      31.509479,
      NULL,
      40,
      48.973540,
      134.421730,
      ' 5-11-1996',
      1.677045,
      0,
      1.142403,
      0,
      1,
      NULL,
      0,
      0.397799,
      1,
      1.466213,
      0,
      1.646390,
      1,
      1.140514,
      0.803222,
      1,
      0,
      NULL,
      0.958907,
      0.511986,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-21-1999',
      93,
      12.522145,
      5.911200,
      NULL,
      10.387001,
      3,
      ' 0-13-2003',
      2,
      1,
      NULL,
      3.714298,
      0.984011,
      26,
      0.279759,
      0.981278,
      59,
      1,
      1.186759,
      6,
      ' 0-29-1979',
      115,
      9,
      56,
      99.251843,
      76.920271,
      72.736086,
      45.173424,
      NULL,
      32.091648,
      53,
      48,
      1,
      NULL,
      9,
      6,
      21.927416,
      9.165053,
      38.103791,
      NULL,
      13.530198,
      ' 0- 8-1995',
      32,
      30.991181,
      '10-14-1979',
      NULL,
      6.251172,
      21,
      1.320516,
      27,
      7.600543,
      0.433908,
      12,
      1.213379,
      NULL,
      7.506152,
      NULL,
      10,
      6,
      2.282580,
      1.305648,
      NULL,
      1.585938,
      NULL,
      1,
      NULL,
      5,
      NULL,
      38.085062,
      0,
      '10-18-1998',
      50,
      NULL,
      NULL,
      16,
      ' 8-23-2000',
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      53.726175,
      12,
      ' 5-29-1975',
      6,
      NULL,
      ' 1-29-1975',
      2,
      6,
      '11-27-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      24,
      45,
      ' 2-27-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.824382);
commit;
end;
/


