set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3355607';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0214',
      '13130234',
      '13024332',
      '12314131',
      '22122200',
      '14340424',
      '44304434',
      '13042341',
      '20221122',
      '03021342',
      '44113244',
      NULL,
      '34444333',
      '11211320',
      '40403443',
      '00024113',
      NULL,
      '10013103',
      '21032024',
      '13413412',
      '42422434',
      '32402312',
      '12322010',
      '13421433',
      '03222120',
      '14240221',
      '00301032',
      '42243431',
      '14130400',
      '24121020',
      '40033243',
      '01121344',
      '40312220',
      '33041013',
      '24104242',
      '23414222',
      NULL,
      NULL,
      NULL,
      '04010100',
      '01042111',
      '03332342',
      '43033200',
      '42422103',
      '41431223',
      NULL,
      '',
      NULL,
      NULL,
      '3022313',
      NULL,
      0.956821,
      0,
      NULL,
      '333023',
      NULL,
      NULL,
      ' 8- 1-1990',
      54.907439,
      NULL,
      NULL,
      14,
      0,
      2.560072,
      15.252629,
      15,
      0,
      2.824599,
      33,
      19.396295,
      20,
      NULL,
      4.899243,
      1,
      11.870751,
      12,
      43.995932,
      3.367597,
      NULL,
      8.646100,
      45.048729,
      1.361503,
      NULL,
      NULL,
      NULL,
      57.918096,
      113.439264,
      56,
      NULL,
      ' 1- 9-1990',
      7,
      NULL,
      17,
      18,
      16.827505,
      21,
      ' 1-16-1975',
      6,
      1.903492,
      10,
      0.347396,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429033,
      NULL,
      0.276370,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1999',
      94,
      17.907668,
      101.985532,
      NULL,
      NULL,
      17.758726,
      NULL,
      5,
      48.598322,
      47.712916,
      79.697594,
      54.183992,
      NULL,
      25,
      10.757097,
      14.412891,
      6,
      25,
      86.560115,
      10.637566,
      NULL,
      7.916328,
      6,
      ' 5-29-1978',
      4,
      6.103441,
      NULL,
      18,
      10,
      11.946509,
      NULL,
      5,
      NULL,
      75,
      1.053118,
      NULL,
      9.467372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      0.188161,
      15.531774,
      ' 0-29-2000',
      NULL,
      NULL,
      ' 5- 9-1984',
      5.500312,
      30,
      1,
      NULL,
      NULL,
      42.273288,
      1.264505,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576473,
      0,
      NULL,
      5,
      3,
      164,
      NULL,
      3,
      81,
      0,
      4,
      160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.051936,
      0.303313,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      12,
      NULL,
      4.106571,
      1.053852,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      7,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      6,
      0,
      2,
      1,
      1.212107,
      0.125854,
      0.929516,
      NULL,
      NULL,
      ' 8-10-1995',
      ' 7- 4-1977',
      ' 1-26-1990',
      ' 4- 7-1991',
      ' 2- 1-1976',
      ' 9-10-1986',
      NULL);
commit;
end;
/


