set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9859288';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '1',
      '1',
      '2',
      '1',
      '0',
      '1',
      '4',
      NULL,
      '3',
      '4',
      '4',
      '2',
      '3',
      '1',
      '1',
      NULL,
      '2',
      '2',
      '3',
      '4',
      '2',
      NULL,
      '',
      NULL,
      '',
      '0',
      NULL,
      '2',
      '4',
      '0',
      '',
      NULL,
      NULL,
      '1',
      '3',
      '2',
      '1',
      '1',
      '2',
      '0',
      '0',
      '3',
      '0',
      '342',
      '30233104',
      NULL,
      7.588915,
      '2341000',
      0,
      1,
      2,
      0,
      '421000',
      3,
      NULL,
      NULL,
      36,
      47.772660,
      NULL,
      12.885861,
      NULL,
      9,
      34,
      22.929020,
      27.949893,
      13,
      18,
      NULL,
      12.163905,
      13,
      23.200837,
      NULL,
      4,
      1,
      9,
      10.226534,
      NULL,
      7.856186,
      138,
      NULL,
      1.208564,
      94,
      239.110595,
      NULL,
      13.884276,
      207.391470,
      58,
      ' 0-28-1989',
      38.082858,
      70.434680,
      21.142724,
      25,
      109,
      28.879645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      7,
      6,
      NULL,
      NULL,
      1.624278,
      NULL,
      0.746698,
      NULL,
      134,
      1.995571,
      1.230388,
      148.014066,
      NULL,
      0.278717,
      15,
      NULL,
      NULL,
      NULL,
      ' 3-26-1990',
      38.590939,
      16,
      NULL,
      12,
      68.952122,
      14,
      12.321772,
      8.783110,
      78.372034,
      69,
      81.042863,
      52.131971,
      ' 7- 6-1992',
      NULL,
      17.775707,
      NULL,
      78.189292,
      19,
      121,
      10.915186,
      NULL,
      14.307463,
      17.107434,
      ' 2-14-1993',
      5.555108,
      6,
      10,
      23,
      NULL,
      NULL,
      NULL,
      17,
      0,
      NULL,
      0,
      3.593362,
      21,
      17,
      1,
      0,
      6.386537,
      NULL,
      ' 3-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      32.549361,
      ' 9-20-1999',
      33.429849,
      NULL,
      7.180135,
      10,
      ' 7- 9-2000',
      71,
      25.244462,
      ' 3-10-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      ' 2-19-1986',
      59.032128,
      30,
      NULL,
      ' 6- 2-1984',
      0,
      3.955973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


