set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7420666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1234',
      '32221000',
      '20002011',
      '02134431',
      NULL,
      '11323222',
      '02023403',
      NULL,
      NULL,
      '11414211',
      '10002040',
      '31421333',
      '24133423',
      '32111310',
      NULL,
      '24242012',
      NULL,
      '14140012',
      '32000132',
      NULL,
      '24234140',
      NULL,
      '43403004',
      NULL,
      '24203121',
      '44420043',
      '02133333',
      NULL,
      NULL,
      '33123030',
      '12232034',
      '02011344',
      NULL,
      '13030210',
      '34204312',
      '14213200',
      '33223230',
      '14411140',
      '32311103',
      '43020113',
      '03441042',
      '20121411',
      '01212302',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      1.922983,
      NULL,
      1,
      NULL,
      '204120',
      1,
      NULL,
      NULL,
      42.791135,
      NULL,
      11.128526,
      10,
      17.916698,
      0,
      2.440457,
      1,
      NULL,
      11.474437,
      19.544938,
      0.024842,
      17,
      NULL,
      2.571385,
      2,
      NULL,
      3.275264,
      0,
      0,
      5.811194,
      NULL,
      12.494406,
      3,
      NULL,
      53.407976,
      155,
      6.281859,
      92.047871,
      47.594895,
      81.284381,
      ' 2- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.733088,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822369,
      10.012137,
      0.471512,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-29-1984',
      1.062702,
      NULL,
      38,
      42,
      NULL,
      33,
      16.537963,
      NULL,
      0.399477,
      NULL,
      30,
      10.505024,
      ' 3-24-1976',
      12,
      5,
      21,
      38,
      19,
      5.289842,
      4,
      NULL,
      0.778887,
      1,
      '10-16-1997',
      10.743542,
      4.443129,
      NULL,
      6,
      5,
      NULL,
      NULL,
      1,
      NULL,
      46,
      15.148234,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      13,
      10,
      NULL,
      18.304332,
      346.095245,
      ' 5- 1-1983',
      6,
      52,
      15,
      59,
      ' 2-16-1977',
      6,
      1,
      160,
      '10-25-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      116.560246,
      70,
      46,
      9.677937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.603519,
      0.129966,
      26,
      3.521669,
      2.081295,
      125.207173,
      8,
      4,
      80,
      5.008164,
      0.474773,
      381.877115,
      4.379356,
      NULL,
      16,
      1,
      12.344006,
      1.546209,
      0,
      0,
      NULL,
      1.338608,
      0.306935,
      53.783588,
      39.178253,
      15.913728,
      NULL,
      8,
      58,
      7.628530,
      0,
      2,
      0.820915,
      6,
      NULL,
      NULL,
      0,
      43.161143,
      NULL,
      2,
      1,
      NULL,
      57.327249,
      26,
      1.894040,
      NULL,
      62.772012,
      NULL,
      6.390566,
      NULL,
      2.186992,
      22,
      0.449119,
      12.236393,
      3.206402,
      1.798762,
      NULL,
      NULL,
      31.849767,
      NULL,
      ' 9- 2-1990',
      ' 2-25-1993',
      ' 0-15-1989',
      ' 8-29-1975',
      NULL,
      ' 3-20-1977',
      NULL);
commit;
end;
/


