set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0000',
      '12000043',
      NULL,
      '42330302',
      '13444130',
      NULL,
      NULL,
      '42023202',
      '30244203',
      '21140101',
      '31422211',
      '03030014',
      '21122121',
      '10424042',
      '24031422',
      '03311400',
      '03011131',
      '34410144',
      '32110213',
      '30311334',
      '34024042',
      NULL,
      '40321104',
      '11122020',
      NULL,
      '10001333',
      NULL,
      '00011012',
      NULL,
      '41133341',
      NULL,
      '04401323',
      '01211040',
      NULL,
      NULL,
      '43312024',
      NULL,
      NULL,
      '43034100',
      '00323434',
      '21112214',
      '20122230',
      '02344441',
      '43010324',
      '31300002',
      '304',
      '40',
      28.576323,
      21,
      '1213140',
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 7-18-1993',
      ' 2-24-1985',
      71,
      17,
      NULL,
      2.822648,
      21,
      1.763730,
      NULL,
      NULL,
      39,
      9.881769,
      5,
      NULL,
      49,
      20,
      22.961653,
      5,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      2.036472,
      82,
      17.872859,
      0.531570,
      135,
      154.989633,
      55.640776,
      NULL,
      171,
      187,
      NULL,
      9,
      NULL,
      9.393326,
      21.597927,
      NULL,
      NULL,
      ' 3-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.940541,
      6,
      2,
      NULL,
      11.576290,
      7,
      '11-18-1998',
      0,
      0,
      14.834009,
      1,
      0,
      NULL,
      1.546927,
      0.220980,
      112.587598,
      NULL,
      NULL,
      NULL,
      ' 2-24-2000',
      59.695826,
      15.329588,
      97.482609,
      4,
      7,
      75.026581,
      50.849951,
      27.047683,
      NULL,
      25.680392,
      2,
      16.715283,
      ' 6- 4-1999',
      25,
      10.134535,
      NULL,
      83.752417,
      24.955047,
      51,
      3.521310,
      ' 7- 8-1987',
      NULL,
      28,
      ' 1-29-1977',
      NULL,
      1,
      29.766372,
      NULL,
      NULL,
      4.442564,
      NULL,
      8.200779,
      1.452496,
      NULL,
      1,
      1,
      NULL,
      8,
      NULL,
      0,
      0.865564,
      1.745348,
      ' 9-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      174.765682,
      18,
      ' 3-27-1997',
      NULL,
      NULL,
      NULL,
      42.389306,
      ' 8-15-1978',
      32.313057,
      NULL,
      7,
      10.296828,
      ' 7-25-1998',
      88.188443,
      77,
      ' 5-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      9.121897,
      ' 3- 5-1975',
      9,
      37.320614,
      NULL,
      ' 6- 8-2003',
      NULL,
      93.680447,
      NULL,
      NULL,
      NULL,
      7.923622,
      24,
      NULL,
      NULL,
      1,
      2.056657,
      ' 9-19-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


