set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9705629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '2',
      NULL,
      '1',
      '4',
      '3',
      '4',
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      '0',
      '4',
      '2',
      '3',
      '1',
      '1',
      '4',
      '2',
      '',
      '2',
      '',
      NULL,
      '4',
      '3',
      '0',
      '3',
      NULL,
      '',
      '3',
      '4',
      '4',
      NULL,
      '1',
      '0',
      '3',
      '4',
      NULL,
      '2',
      '0',
      '321',
      '20014301',
      22.366887,
      45,
      '4343434',
      0,
      12,
      3,
      NULL,
      '340114',
      1.463530,
      '11-13-1978',
      ' 2-22-1986',
      68,
      202,
      12.279909,
      NULL,
      18,
      12.293899,
      6.462650,
      33,
      0,
      NULL,
      NULL,
      8,
      52.232411,
      NULL,
      7.988891,
      6.068895,
      30.756839,
      NULL,
      NULL,
      4.149887,
      10,
      9.434061,
      138.498162,
      NULL,
      1,
      NULL,
      233,
      59.581685,
      NULL,
      154,
      156.453827,
      ' 1-20-1979',
      70,
      45.676184,
      8,
      40.361639,
      72.595548,
      170,
      ' 5-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      2,
      2,
      5.743870,
      13.787722,
      5.307839,
      ' 0-27-2003',
      NULL,
      NULL,
      132.550569,
      1,
      1.928462,
      88,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-1999',
      6,
      48,
      NULL,
      20.710635,
      3,
      7.748105,
      22,
      9,
      20,
      56,
      NULL,
      14,
      ' 6-21-1979',
      14.230694,
      NULL,
      NULL,
      84.147203,
      66,
      51,
      0.577264,
      ' 2-24-2003',
      15.981246,
      26.704285,
      NULL,
      NULL,
      NULL,
      22,
      10,
      17,
      NULL,
      NULL,
      6.559331,
      1,
      146,
      2,
      0,
      21.806225,
      14.437207,
      1.289213,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      161.554710,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      '11-23-1988',
      23.131046,
      NULL,
      1.004950,
      14,
      '10-15-1982',
      71,
      63,
      ' 2- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      19.498022,
      ' 7-13-1989',
      57,
      20.387782,
      38.823249,
      ' 8-10-1987',
      2.130076,
      NULL,
      NULL,
      9,
      2,
      6,
      NULL,
      ' 2-19-1990',
      64,
      0,
      8.998714,
      ' 4- 8-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


