set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9933915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '0',
      '4',
      '0',
      '2',
      NULL,
      '3',
      '3',
      '2',
      NULL,
      '3',
      '2',
      '0',
      '3',
      '4',
      '2',
      '3',
      '4',
      '4',
      '4',
      '4',
      NULL,
      '0',
      '',
      NULL,
      '',
      '1',
      '4',
      '4',
      '1',
      NULL,
      '',
      '',
      '4',
      NULL,
      '1',
      '0',
      '3',
      '3',
      '0',
      '2',
      '1',
      '1',
      '4',
      NULL,
      '30210041',
      13.944338,
      50.147957,
      '1101220',
      3.873245,
      0,
      NULL,
      0,
      NULL,
      6.244617,
      ' 6-20-1994',
      ' 7-29-1981',
      63.738110,
      95,
      7,
      5.448390,
      NULL,
      0.034587,
      27.365480,
      2.834951,
      5.307332,
      1,
      13,
      4,
      25.263785,
      16.575882,
      26,
      1.267996,
      13,
      13.856957,
      8,
      3,
      28,
      13.858991,
      31.269439,
      11.729896,
      0,
      57,
      69,
      27,
      106,
      NULL,
      119,
      ' 9-19-1998',
      21.963047,
      13.265102,
      20.734269,
      NULL,
      187.414878,
      160.187973,
      ' 8-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      11.535271,
      9,
      NULL,
      19,
      1,
      NULL,
      0.905023,
      0.054232,
      NULL,
      0.910449,
      0,
      NULL,
      0,
      5,
      42,
      NULL,
      NULL,
      NULL,
      ' 6-18-1999',
      6,
      28,
      17.730068,
      40,
      1,
      NULL,
      NULL,
      52,
      20,
      NULL,
      2,
      43.550327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542139,
      1,
      ' 0- 0-1988',
      0.978795,
      NULL,
      ' 4-17-1998',
      3.629243,
      6.966980,
      2,
      0.381518,
      2,
      3,
      0.389307,
      1,
      1.594366,
      14,
      7.436895,
      1.885743,
      2.872224,
      5.620685,
      22.568598,
      NULL,
      0.278741,
      0,
      ' 5-29-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      68.724644,
      NULL,
      ' 9- 8-1982',
      NULL,
      NULL,
      NULL,
      18,
      ' 8- 1-1984',
      13.405435,
      ' 2-19-1975',
      9.543432,
      7.203136,
      ' 4- 5-1976',
      19,
      38,
      ' 3-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 9-14-1999',
      8.406691,
      3.355939,
      2,
      NULL,
      1,
      150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


