set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8236807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0131',
      NULL,
      '33104012',
      '03431022',
      '40143024',
      '14120310',
      '32002214',
      '31004324',
      '12321013',
      '32131102',
      '34030311',
      '10030134',
      '33430100',
      '22222223',
      NULL,
      NULL,
      '23244244',
      '33304434',
      '12141013',
      '44144233',
      '42441342',
      '32230323',
      NULL,
      NULL,
      NULL,
      NULL,
      '02104142',
      NULL,
      '13124014',
      NULL,
      '14433422',
      '00330040',
      '33124242',
      '32201410',
      '03343244',
      '01322133',
      '10334322',
      '14030232',
      '42021214',
      '24244220',
      '23422401',
      '02230210',
      '40433204',
      '34202021',
      '24140023',
      '433',
      '44',
      NULL,
      NULL,
      '1024322',
      1.886436,
      0.352898,
      3,
      NULL,
      '420044',
      5.042776,
      ' 3- 0-1981',
      ' 2-18-1994',
      NULL,
      NULL,
      41.268134,
      1,
      NULL,
      5,
      NULL,
      16.130894,
      NULL,
      9.926809,
      29.580766,
      26,
      6.341395,
      13,
      12.530346,
      7.779447,
      20.308014,
      5.644679,
      NULL,
      27,
      34,
      21.493083,
      NULL,
      NULL,
      0.516223,
      93.417705,
      NULL,
      NULL,
      153,
      175,
      192,
      NULL,
      27.167182,
      45,
      NULL,
      37,
      96,
      159,
      ' 9- 0-1978',
      1.050734,
      0,
      0.587357,
      1,
      0.791758,
      NULL,
      NULL,
      1.459638,
      1,
      NULL,
      NULL,
      0.683498,
      NULL,
      NULL,
      1.029335,
      NULL,
      NULL,
      1.871520,
      0,
      1.449954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.244249,
      1,
      2,
      8.527103,
      2.041766,
      1,
      ' 4-22-1988',
      1,
      0,
      66.210728,
      NULL,
      1,
      131.452507,
      1,
      0.589316,
      NULL,
      1,
      NULL,
      16,
      ' 5-18-2000',
      58.513252,
      1,
      NULL,
      82,
      66,
      3,
      96.321037,
      NULL,
      79,
      NULL,
      56.570944,
      65.532780,
      ' 0-24-1975',
      10,
      23,
      24,
      63.318761,
      39,
      59.336819,
      3.669877,
      ' 6- 3-1975',
      5,
      1.317923,
      ' 3- 4-1976',
      6,
      8,
      29.964331,
      NULL,
      10.600050,
      NULL,
      0.347012,
      9,
      0.349949,
      117.802943,
      0.138647,
      1.376012,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      1,
      ' 4- 3-1998',
      NULL,
      2.567604,
      4,
      ' 8- 4-1989',
      314.972334,
      0.174159,
      ' 7-11-1995',
      NULL,
      0.338893,
      NULL,
      47.952482,
      ' 9-17-1992',
      13,
      '11-16-1986',
      12,
      15.902397,
      ' 4- 5-1979',
      19,
      41.185234,
      ' 0-22-1990',
      0.044598,
      14,
      ' 0-23-1979',
      3,
      5.502921,
      ' 2- 1-1985',
      3,
      1,
      NULL,
      NULL,
      14.371006,
      14,
      19,
      ' 4-27-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6);
commit;
end;
/


