set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828643';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4300',
      '31210301',
      '43341003',
      '42220420',
      '31340431',
      '23313112',
      '04404021',
      '43302024',
      '02413301',
      NULL,
      '24403023',
      '13334112',
      NULL,
      '42323023',
      '43041030',
      NULL,
      NULL,
      '44024110',
      '24110200',
      '43341144',
      '00002423',
      '14230001',
      '30413110',
      '22123122',
      '41003000',
      NULL,
      '23041341',
      '00421122',
      '01144430',
      '02202302',
      '41403314',
      '11323311',
      '00432212',
      '42214221',
      '32322002',
      NULL,
      '01023030',
      '41043031',
      '22200020',
      '33402103',
      NULL,
      '41330444',
      NULL,
      '20310313',
      NULL,
      '103',
      '40',
      NULL,
      NULL,
      '2222202',
      NULL,
      1.111365,
      1,
      NULL,
      NULL,
      3,
      ' 5-19-2000',
      NULL,
      28,
      NULL,
      20,
      22.061508,
      NULL,
      3.737199,
      42.491102,
      16,
      5,
      NULL,
      1,
      1.187625,
      2,
      7.811434,
      22,
      20,
      18,
      18.082994,
      23.774057,
      NULL,
      64.408102,
      0,
      106,
      9,
      0.601919,
      NULL,
      132.816075,
      48,
      84.773032,
      8,
      NULL,
      ' 8- 6-2003',
      NULL,
      33,
      4.821655,
      13,
      167.056158,
      104,
      ' 9-25-2003',
      4.401367,
      0.871383,
      1.889656,
      NULL,
      0,
      0.115075,
      0.018478,
      0,
      1,
      1.079819,
      2,
      0,
      NULL,
      2.058426,
      0.595412,
      1,
      1,
      0.487128,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-22-1982',
      NULL,
      0,
      4.583717,
      NULL,
      6,
      3.158314,
      ' 0-16-1983',
      1,
      1,
      111,
      0,
      0.697633,
      101.839019,
      1,
      1.059852,
      88,
      NULL,
      NULL,
      NULL,
      ' 2-26-1999',
      NULL,
      44,
      NULL,
      NULL,
      112,
      108,
      NULL,
      45,
      2.639284,
      60.123253,
      79,
      7,
      ' 1-18-2002',
      12,
      NULL,
      NULL,
      7,
      38.637405,
      21,
      2,
      ' 7-10-1988',
      4,
      18,
      '11-23-1975',
      NULL,
      NULL,
      13,
      15,
      NULL,
      NULL,
      NULL,
      15.661998,
      0,
      66,
      0,
      NULL,
      22.017883,
      12.992262,
      3.391289,
      NULL,
      0,
      NULL,
      ' 8-17-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      41.294652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      '11-27-2001',
      33,
      '10-21-1989',
      8.683272,
      NULL,
      ' 1-11-1987',
      102,
      NULL,
      ' 7-18-1989',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      ' 9-16-1985',
      58.986098,
      11,
      16.302703,
      ' 8- 1-1981',
      NULL,
      97.612784,
      ' 1- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


