set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8322667';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '4',
      NULL,
      '3',
      '2',
      '3',
      '3',
      NULL,
      NULL,
      '4',
      '4',
      '2',
      NULL,
      '4',
      '2',
      '1',
      '2',
      '2',
      '1',
      '3',
      '4',
      '4',
      NULL,
      '',
      '4',
      '',
      NULL,
      NULL,
      '3',
      '3',
      '3',
      '',
      '',
      '3',
      '1',
      '3',
      '0',
      NULL,
      '3',
      '0',
      '4',
      '1',
      '2',
      '2',
      '434',
      '03210132',
      14,
      27,
      '3213142',
      1.787658,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      ' 0- 3-1975',
      168.112811,
      NULL,
      45.703717,
      NULL,
      1,
      9,
      74,
      20,
      15.777093,
      18.669259,
      NULL,
      18,
      NULL,
      18,
      9,
      5.287073,
      7.341559,
      NULL,
      NULL,
      NULL,
      NULL,
      27.816785,
      80,
      7,
      1,
      97.176202,
      179.968600,
      26.637436,
      97,
      NULL,
      104,
      ' 8-26-1976',
      31,
      10,
      31,
      NULL,
      12,
      90,
      ' 3- 4-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      18.659971,
      22.850024,
      6,
      NULL,
      5.450110,
      ' 6-24-1985',
      0,
      0,
      NULL,
      1.496388,
      1,
      NULL,
      NULL,
      NULL,
      101.870771,
      NULL,
      NULL,
      NULL,
      '10-22-1995',
      21.225056,
      45,
      28.385080,
      14,
      22.301454,
      14.552474,
      72.344816,
      24.161399,
      48,
      76,
      29,
      13.384182,
      ' 6-29-1976',
      NULL,
      13.709470,
      15.632242,
      19,
      24.592512,
      NULL,
      4,
      ' 4-18-1981',
      26,
      NULL,
      ' 8-27-1989',
      NULL,
      0,
      13,
      NULL,
      NULL,
      11.261799,
      0.545636,
      3.307968,
      NULL,
      112.499136,
      1,
      NULL,
      19,
      NULL,
      1.692608,
      NULL,
      0.745619,
      1.193422,
      ' 2- 4-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.133962,
      ' 4-12-1979',
      NULL,
      NULL,
      NULL,
      34.839102,
      NULL,
      36,
      ' 8-24-1982',
      15,
      5.009061,
      ' 5-13-1980',
      119,
      NULL,
      ' 5- 9-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      6.040539,
      11,
      52.582224,
      ' 7- 0-1976',
      0,
      NULL,
      ' 6- 2-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


