set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6302129';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4231',
      '03240334',
      '42133441',
      '30033210',
      '10433314',
      '42202233',
      '31432404',
      NULL,
      '10331031',
      '40420232',
      '31410104',
      '23200044',
      '14121442',
      '42400331',
      '02102341',
      '01020322',
      NULL,
      '34013244',
      '34133111',
      '02014304',
      '04003233',
      '03314031',
      NULL,
      '33244400',
      '13032111',
      '43044314',
      NULL,
      '32240103',
      '03431221',
      '14140220',
      NULL,
      '10014113',
      '21103043',
      '33410324',
      '34411140',
      '22312200',
      '42123102',
      '43410124',
      '32344434',
      '13041143',
      '01034443',
      '04213123',
      NULL,
      '11300031',
      '03123312',
      '',
      '',
      NULL,
      NULL,
      '4400232',
      3.789033,
      0.831074,
      3,
      NULL,
      NULL,
      NULL,
      ' 7- 6-2001',
      ' 6- 4-1996',
      NULL,
      NULL,
      4.173104,
      NULL,
      8.682285,
      9,
      102,
      NULL,
      NULL,
      21,
      40,
      NULL,
      49,
      18,
      15.804058,
      13,
      NULL,
      0,
      52,
      15,
      0.984376,
      22.686313,
      92,
      NULL,
      NULL,
      NULL,
      206.582641,
      45.403444,
      123,
      37.047440,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      24,
      184.293764,
      160,
      ' 1-12-1980',
      2.498851,
      0.892672,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.511442,
      3.944458,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-23-1975',
      45.478439,
      NULL,
      61,
      NULL,
      NULL,
      103.551144,
      97.990363,
      9.611973,
      69,
      NULL,
      NULL,
      72,
      NULL,
      38,
      NULL,
      NULL,
      110,
      55,
      154,
      3.930088,
      ' 8- 8-2003',
      14,
      9,
      NULL,
      2,
      12,
      12.081362,
      NULL,
      9.523683,
      NULL,
      NULL,
      7.786642,
      NULL,
      42.652205,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.608680,
      11,
      14.440753,
      '10-25-1982',
      0.154301,
      74,
      ' 8-12-1997',
      3.562896,
      17,
      3.199458,
      NULL,
      NULL,
      67.310087,
      NULL,
      79,
      '11-13-1982',
      NULL,
      NULL,
      NULL,
      52,
      98,
      13.513073,
      61,
      50,
      44.689425,
      128.451694,
      NULL,
      NULL,
      52.966653,
      5.163661,
      89,
      NULL,
      1.050949,
      22,
      2,
      NULL,
      54.815733,
      0,
      1,
      106,
      0.852718,
      1.076409,
      19,
      60.608115,
      20.647982,
      2.809361,
      NULL,
      54.318417,
      NULL,
      1,
      1.933363,
      0.599000,
      1.586320,
      1.826425,
      NULL,
      10.560158,
      75,
      NULL,
      37.618732,
      30.148894,
      2.527192,
      4,
      12,
      0,
      4.523627,
      4,
      30.126347,
      NULL,
      NULL,
      1.671262,
      65.000907,
      NULL,
      NULL,
      34,
      27,
      5.059180,
      16.943074,
      79.647645,
      44,
      NULL,
      96,
      5,
      16,
      1,
      21.496696,
      2,
      1.686703,
      0,
      1.382056,
      NULL,
      ' 6-13-2003',
      ' 2- 7-1979',
      ' 9-13-1996',
      NULL,
      '10-25-1995',
      ' 7-17-1995',
      ' 3-18-2001',
      NULL);
commit;
end;
/


