set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228116';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421',
      '13403444',
      '02002422',
      '02421103',
      '32031213',
      '14244423',
      NULL,
      NULL,
      '10344213',
      '31202343',
      '22441401',
      '20114400',
      '42320210',
      '43004230',
      '44443331',
      '04302012',
      '43004142',
      '42323411',
      '41031010',
      '23323044',
      '32303234',
      '42323221',
      NULL,
      '10140240',
      '30244004',
      '22402441',
      '41444230',
      NULL,
      '04443333',
      '43241403',
      '33004044',
      '04203124',
      '30310102',
      '32320404',
      '34110004',
      '40022444',
      '32132214',
      NULL,
      '42332010',
      NULL,
      '31204431',
      '00430140',
      '24230242',
      '11240313',
      '40200413',
      '424',
      '32',
      NULL,
      NULL,
      '2210231',
      2,
      NULL,
      1,
      NULL,
      '011214',
      5,
      '10- 9-1997',
      ' 1-20-1983',
      33.091253,
      NULL,
      38,
      3,
      18,
      11,
      35,
      5,
      10.905301,
      6.712601,
      48,
      9,
      26.807851,
      24,
      5,
      5,
      21.805348,
      NULL,
      32,
      26,
      1,
      10.897381,
      NULL,
      9.733632,
      NULL,
      85.570594,
      109,
      94,
      118.774705,
      122,
      201,
      ' 2-13-1995',
      NULL,
      31,
      3,
      9.901558,
      186.145358,
      99,
      ' 4-10-1986',
      NULL,
      0,
      0,
      NULL,
      0.299060,
      1.713460,
      0,
      2.586098,
      NULL,
      NULL,
      NULL,
      0.911255,
      NULL,
      0,
      1.076975,
      1.392180,
      1.989042,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1982',
      NULL,
      8.377041,
      6,
      0.074917,
      7,
      NULL,
      ' 5-20-1977',
      NULL,
      0.881732,
      3,
      1,
      0.789819,
      71.102392,
      1,
      1,
      33.365481,
      NULL,
      NULL,
      145.247095,
      ' 1- 8-1994',
      NULL,
      13,
      70.654618,
      91,
      87,
      87,
      4,
      93,
      10.962023,
      114,
      88.443098,
      98,
      NULL,
      7.414962,
      NULL,
      9.615238,
      NULL,
      NULL,
      152,
      NULL,
      ' 3-22-1979',
      28.573777,
      NULL,
      ' 1-15-1984',
      6.836894,
      7,
      11.403988,
      26,
      17.625764,
      2,
      0.535817,
      NULL,
      3,
      56,
      NULL,
      1.087997,
      NULL,
      5.781876,
      NULL,
      1.541962,
      1,
      0.521752,
      ' 5- 2-2000',
      6.876972,
      NULL,
      4,
      ' 8- 3-1982',
      6.841033,
      0.529865,
      '10- 6-1999',
      17,
      1.880729,
      NULL,
      19.054901,
      ' 0- 8-1992',
      NULL,
      '10- 3-1997',
      10.646854,
      14,
      ' 2-27-1998',
      109.704154,
      83.078299,
      ' 8- 8-1993',
      2.611620,
      13,
      ' 6- 9-2003',
      6,
      8,
      ' 2- 4-1986',
      1,
      NULL,
      25.743334,
      NULL,
      25.711367,
      30,
      NULL,
      ' 3- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


