set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7944730';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0031',
      NULL,
      '31201412',
      NULL,
      NULL,
      '33141441',
      '32403433',
      NULL,
      NULL,
      '10022101',
      '22033112',
      '31343444',
      '02031344',
      '41444110',
      '34202433',
      '14010144',
      NULL,
      '11143431',
      '42331200',
      '23142122',
      '30234430',
      '21221032',
      '03421202',
      '34212411',
      '12342241',
      NULL,
      '42110103',
      '01440223',
      '21233014',
      '23003142',
      NULL,
      NULL,
      '14414123',
      '13421003',
      '14132301',
      '24311003',
      '24001240',
      '13121223',
      '22132124',
      '00201040',
      '11040210',
      '10024124',
      '44041401',
      '11433144',
      '43433011',
      '410',
      NULL,
      NULL,
      NULL,
      '1111312',
      2.082709,
      1.872206,
      1,
      NULL,
      '340133',
      NULL,
      ' 7- 7-1988',
      ' 5-20-1988',
      86.688064,
      NULL,
      19,
      11.658965,
      NULL,
      NULL,
      66,
      11.690739,
      4,
      NULL,
      NULL,
      NULL,
      11.330897,
      3.523492,
      13,
      11.900332,
      1.745804,
      2.225213,
      12,
      3.649130,
      22,
      10,
      15,
      1.845565,
      0,
      NULL,
      58,
      0.243517,
      54,
      89,
      58.907786,
      ' 2-26-1998',
      NULL,
      1,
      19,
      NULL,
      81.984824,
      53.652866,
      ' 6- 2-1982',
      3,
      0.314753,
      2.483093,
      1,
      5,
      0,
      6.071901,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.439589,
      0,
      1,
      2,
      2.796203,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-20-1982',
      20,
      60.542824,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-28-1991',
      1.951494,
      NULL,
      165,
      NULL,
      NULL,
      0,
      0,
      NULL,
      4.205536,
      1,
      3,
      175,
      ' 1-19-1996',
      60,
      8.454689,
      59.878453,
      NULL,
      54.564761,
      9,
      9.017387,
      3.513313,
      NULL,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      8.908561,
      16.470614,
      31.497491,
      4.421050,
      5.122896,
      ' 8-28-1988',
      14,
      12,
      NULL,
      NULL,
      12,
      1,
      14.374881,
      NULL,
      0.168409,
      2,
      12.334085,
      0.991057,
      79.536422,
      NULL,
      NULL,
      4,
      NULL,
      2.224852,
      0.587155,
      0,
      1,
      NULL,
      NULL,
      1.115821,
      1,
      ' 0-28-1979',
      141.999710,
      99.445344,
      ' 8- 5-1983',
      NULL,
      NULL,
      NULL,
      18.435140,
      ' 5-21-1991',
      NULL,
      '10-11-1987',
      10,
      1,
      '10-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      13,
      ' 5-23-2000',
      3,
      0,
      7.712092,
      ' 0-14-1985',
      28.758501,
      16.449064,
      23.016531,
      '10-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2);
commit;
end;
/


