set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4801449';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0001',
      NULL,
      NULL,
      '42012000',
      '44304121',
      '13414034',
      NULL,
      '41131322',
      '13232203',
      NULL,
      '01223324',
      '42142124',
      '00332213',
      '33021032',
      '02320143',
      NULL,
      '13442224',
      '23000134',
      '44103123',
      '33121044',
      '12121330',
      '40011204',
      '03040421',
      '32044302',
      NULL,
      '03404323',
      '04140223',
      '30424130',
      '00131104',
      '33000140',
      '21010303',
      '24412424',
      '32012232',
      NULL,
      '22414332',
      '12023212',
      '03444103',
      NULL,
      '04413143',
      NULL,
      '12012412',
      '01220132',
      '11031144',
      NULL,
      '33032102',
      '',
      '',
      NULL,
      NULL,
      '3113303',
      0.730618,
      0,
      1,
      NULL,
      NULL,
      1.518491,
      ' 6- 0-1991',
      ' 7-22-1974',
      32.392189,
      NULL,
      NULL,
      7.686022,
      2,
      NULL,
      104,
      20,
      19.179872,
      15,
      6,
      1,
      30,
      17.679475,
      33.282951,
      5,
      NULL,
      4,
      13.599387,
      9,
      19,
      12,
      33,
      0.815519,
      NULL,
      NULL,
      84.150570,
      76,
      73,
      62.456055,
      141,
      ' 4-21-1985',
      69.039118,
      NULL,
      1.040475,
      NULL,
      46.109491,
      8.028187,
      NULL,
      0,
      11,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.859074,
      1.166474,
      7,
      0,
      0.543683,
      1.331571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-12-1995',
      25.237744,
      10.854701,
      NULL,
      17,
      70.517932,
      35.138645,
      67,
      52,
      34.052368,
      45,
      26,
      66.686216,
      ' 8-25-1977',
      1.379181,
      0.613294,
      NULL,
      34.125435,
      15.702193,
      52,
      7,
      ' 4- 4-2000',
      5,
      9.332207,
      NULL,
      5,
      NULL,
      11,
      13,
      7.690380,
      6.800008,
      NULL,
      NULL,
      NULL,
      79,
      0,
      1.181417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.407661,
      NULL,
      33,
      ' 7-29-1989',
      1,
      NULL,
      ' 0- 6-1984',
      NULL,
      40.357298,
      NULL,
      77,
      ' 7-19-1986',
      40,
      0.969633,
      139,
      ' 8- 1-1993',
      NULL,
      NULL,
      NULL,
      7.037406,
      NULL,
      34,
      106,
      27.497631,
      83.617712,
      NULL,
      6,
      14,
      1.561170,
      7,
      90.056824,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345811,
      NULL,
      164,
      3,
      1.764499,
      442,
      18.864277,
      NULL,
      120.806588,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.740604,
      0.436226,
      0.700338,
      47,
      9.193507,
      58,
      18.219696,
      45,
      118.043632,
      6,
      6,
      14,
      5,
      11,
      NULL,
      5,
      NULL,
      1,
      1.243351,
      91,
      NULL,
      NULL,
      75,
      26,
      10,
      16.945317,
      98.956658,
      62,
      6,
      NULL,
      NULL,
      10,
      0,
      4.163984,
      0.299497,
      1.699123,
      0,
      0.169950,
      NULL,
      ' 6-24-1994',
      ' 1-19-1996',
      ' 4-27-1983',
      NULL,
      ' 4-19-1997',
      ' 8- 3-1983',
      ' 0-11-1980',
      NULL);
commit;
end;
/


