set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9419211';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1204',
      '34003022',
      NULL,
      '31442423',
      '44233220',
      '14331424',
      NULL,
      '43013330',
      NULL,
      '04330104',
      '31311302',
      '23122120',
      '44343131',
      '22324240',
      '02434104',
      '41204112',
      '31220303',
      '10221212',
      '01421033',
      '11411324',
      '10023020',
      '14211342',
      '33131320',
      NULL,
      '43031133',
      '44341303',
      '22414042',
      '01004100',
      '01124233',
      NULL,
      '04422412',
      '33340224',
      '13404212',
      '31210434',
      '42443414',
      '21241423',
      '00103422',
      '40433212',
      '40042243',
      '01412010',
      '03440304',
      '20444213',
      '34004142',
      '31320043',
      '01033233',
      '334',
      NULL,
      NULL,
      NULL,
      '4431124',
      3,
      1.423674,
      1,
      NULL,
      '200413',
      NULL,
      ' 9-28-1978',
      ' 9-25-2000',
      15.082674,
      NULL,
      NULL,
      14,
      19,
      6,
      83.279161,
      NULL,
      NULL,
      10.098889,
      23,
      14,
      NULL,
      NULL,
      21.385293,
      3.615841,
      15,
      10,
      34.164325,
      18,
      67.446023,
      21.325269,
      1,
      7.412228,
      1.406707,
      12,
      93,
      NULL,
      200.785856,
      NULL,
      1.949774,
      ' 4-19-1975',
      53.647272,
      60.888863,
      8,
      1,
      161.132834,
      78.481854,
      ' 2-13-1984',
      1,
      NULL,
      0,
      2.122879,
      9.766595,
      NULL,
      11,
      NULL,
      3.138624,
      NULL,
      3,
      NULL,
      0.218285,
      NULL,
      0.244587,
      1.849268,
      5,
      0,
      0.795621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-16-1977',
      63,
      NULL,
      6.375317,
      5.121124,
      4.636800,
      NULL,
      '10-16-1993',
      1,
      1.213752,
      85,
      1,
      0,
      134.432196,
      1.371743,
      0,
      97,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1999',
      2.049696,
      53,
      42.057295,
      36.683019,
      22.526595,
      72.843622,
      87,
      40,
      46.114797,
      64.339689,
      NULL,
      60.502590,
      NULL,
      NULL,
      1.340949,
      NULL,
      NULL,
      NULL,
      61.820424,
      NULL,
      ' 2-10-1976',
      4,
      24.790700,
      ' 7-27-1995',
      5.666369,
      NULL,
      NULL,
      2,
      13.168600,
      NULL,
      1,
      23,
      0.115011,
      39,
      0.939802,
      0,
      6,
      8,
      0,
      3,
      0.818939,
      1.746204,
      ' 3-20-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      7.564210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 3-1992',
      6,
      NULL,
      7.944443,
      NULL,
      NULL,
      131,
      NULL,
      ' 2-26-1999',
      NULL,
      0,
      ' 5-14-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      10,
      ' 1- 6-1987',
      31,
      11,
      NULL,
      NULL,
      1.545886,
      11.105998,
      ' 7-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


