set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8714721';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3242',
      NULL,
      '14231410',
      '31431334',
      '22234400',
      NULL,
      '42333232',
      '20110103',
      '43101310',
      NULL,
      '20043023',
      '34123302',
      NULL,
      '03133200',
      '14341234',
      '31001300',
      NULL,
      '34024423',
      '00103232',
      '22240443',
      '34011124',
      '33144112',
      '22100420',
      NULL,
      '44244212',
      '13330112',
      NULL,
      '23440022',
      '41141233',
      '31040202',
      '40331000',
      '22000010',
      '23444303',
      NULL,
      NULL,
      '24002023',
      '01211034',
      NULL,
      NULL,
      NULL,
      '24231214',
      NULL,
      '21222312',
      '01323324',
      '01314333',
      NULL,
      '',
      NULL,
      NULL,
      '3013324',
      3.919530,
      NULL,
      0,
      NULL,
      '114320',
      3.134430,
      ' 7-28-1986',
      ' 1- 8-1986',
      NULL,
      NULL,
      17,
      12.126336,
      6,
      24,
      NULL,
      16.041465,
      20.791176,
      6,
      38,
      19.697887,
      18.560656,
      2,
      3,
      11,
      2,
      NULL,
      0.461633,
      1,
      17,
      NULL,
      NULL,
      12.614539,
      NULL,
      91.449697,
      NULL,
      24.287388,
      NULL,
      NULL,
      183.515092,
      ' 4- 0-1982',
      NULL,
      14.592480,
      NULL,
      20.567636,
      24.730713,
      47.824999,
      ' 3-28-1992',
      3,
      NULL,
      10.536285,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.289521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-2000',
      62,
      15,
      NULL,
      23,
      9,
      NULL,
      23.578020,
      95,
      NULL,
      1.198650,
      26,
      100.987645,
      ' 2-20-1980',
      7.636912,
      3,
      NULL,
      NULL,
      76.270679,
      90,
      8.943367,
      ' 9- 0-2003',
      27,
      10.324446,
      '10-24-1976',
      4.656334,
      3,
      NULL,
      11,
      19.422428,
      NULL,
      NULL,
      5.606952,
      NULL,
      NULL,
      5.819212,
      0,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      7,
      5,
      ' 0-26-1993',
      1.473480,
      NULL,
      ' 6-15-2000',
      0,
      22,
      17.194103,
      19,
      NULL,
      30.549832,
      0.825753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      49,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      77.023801,
      NULL,
      0,
      5.388295,
      0,
      NULL,
      87.625196,
      0,
      NULL,
      105.309157,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      2.663001,
      1.627285,
      1.885166,
      NULL,
      NULL,
      NULL,
      3.611086,
      NULL,
      NULL,
      2,
      2,
      30.768914,
      0.819779,
      1,
      1.076142,
      36,
      3.749164,
      NULL,
      0,
      NULL,
      0.607017,
      NULL,
      NULL,
      16.609957,
      NULL,
      8,
      NULL,
      NULL,
      3.166944,
      NULL,
      NULL,
      15,
      1.285974,
      3.104232,
      3,
      3,
      2,
      1.836758,
      NULL,
      NULL,
      ' 0-22-1983',
      ' 5-23-2003',
      ' 0-20-1983',
      NULL,
      ' 0- 4-1978',
      ' 1- 0-1979',
      NULL);
commit;
end;
/


