set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9691800';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1203',
      '11230342',
      NULL,
      '34431314',
      NULL,
      NULL,
      '04034240',
      '24343310',
      '34244011',
      '13012320',
      NULL,
      '14210230',
      '40342430',
      '40343141',
      '24341021',
      '01211110',
      '43212410',
      '33402340',
      '01130111',
      '10233224',
      NULL,
      '32022044',
      NULL,
      '04110300',
      NULL,
      '20124023',
      '12121300',
      '02034134',
      '23240233',
      '04312204',
      NULL,
      '01220430',
      '43123122',
      '42323244',
      '21012421',
      '42443013',
      '20242032',
      '43323030',
      NULL,
      '01240124',
      '43420022',
      NULL,
      '33222413',
      '20312103',
      '14322014',
      NULL,
      '02',
      5,
      15,
      '2340444',
      2,
      NULL,
      NULL,
      NULL,
      '102342',
      2,
      '10-21-1987',
      ' 3-14-1981',
      30,
      9.272440,
      8,
      1.678153,
      21,
      0.291306,
      NULL,
      12.907798,
      19.003795,
      9,
      25.247675,
      3,
      2,
      NULL,
      18.228547,
      5.133325,
      28.249221,
      NULL,
      27,
      8.732764,
      64.610066,
      18.817146,
      37,
      6.472092,
      NULL,
      46,
      100.684365,
      31.402735,
      13,
      133,
      23.024167,
      ' 1-19-2002',
      24.522764,
      55.483817,
      NULL,
      28,
      65.969893,
      115,
      ' 2- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      25.011541,
      NULL,
      7.488754,
      5.251000,
      NULL,
      ' 2- 8-1998',
      3,
      0,
      NULL,
      0,
      NULL,
      29.839078,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1976',
      75.593695,
      23,
      55.098220,
      32,
      28,
      72.514118,
      63,
      72,
      38.065833,
      22,
      NULL,
      79.762176,
      ' 6-28-1979',
      NULL,
      NULL,
      20,
      58.640963,
      31.552554,
      31,
      9,
      ' 0- 3-1979',
      8,
      0,
      NULL,
      10.984958,
      7.380987,
      8,
      10,
      8,
      9,
      1.312857,
      7,
      1,
      NULL,
      0.313140,
      1.987870,
      0.207853,
      0.803173,
      11,
      NULL,
      1,
      1,
      '10-29-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      241.019561,
      15,
      '11- 8-1978',
      NULL,
      NULL,
      NULL,
      12,
      '11- 5-1999',
      31.311902,
      NULL,
      2,
      4,
      NULL,
      50.029047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4,
      ' 4-19-1998',
      30,
      36.172324,
      5.506268,
      ' 2- 9-1979',
      NULL,
      213,
      ' 6-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


