set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9768752';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '0',
      '4',
      '3',
      '4',
      '4',
      '0',
      '4',
      '4',
      '0',
      '3',
      '4',
      '0',
      '0',
      '3',
      '3',
      NULL,
      '1',
      '2',
      '2',
      '1',
      '2',
      '4',
      '',
      NULL,
      '',
      '4',
      '1',
      '3',
      '1',
      '3',
      '',
      NULL,
      '4',
      '2',
      '4',
      '4',
      '4',
      '1',
      '3',
      NULL,
      '4',
      '0',
      '3',
      '044',
      '30133304',
      9,
      37.807622,
      NULL,
      3.003677,
      0.655219,
      2,
      0,
      '003313',
      2,
      ' 4-28-1997',
      ' 6- 0-1976',
      85.398490,
      40.082023,
      21,
      24.164386,
      18.758453,
      17,
      96,
      24,
      10.625205,
      11,
      50.399651,
      8.827731,
      28,
      6.100789,
      35.394166,
      3.307772,
      15.358452,
      16.654541,
      5.245600,
      24,
      43,
      30.934406,
      78.349619,
      22,
      NULL,
      103,
      211,
      75.549335,
      230.929906,
      17.434785,
      64.820878,
      ' 7- 0-1978',
      26.569217,
      31.928839,
      12.033441,
      15.626653,
      178.846176,
      23.436409,
      ' 2-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.289600,
      18.862406,
      38,
      7,
      20.664872,
      7,
      NULL,
      0.495556,
      0.968996,
      183,
      1.025849,
      0.021492,
      175,
      4.467997,
      0,
      44.643986,
      NULL,
      NULL,
      NULL,
      ' 4-14-1989',
      NULL,
      76.410783,
      117,
      92,
      NULL,
      NULL,
      NULL,
      105.269947,
      81.257803,
      93,
      55.611030,
      87,
      '11-12-1991',
      21.064107,
      2,
      NULL,
      NULL,
      57.012456,
      34.348312,
      NULL,
      ' 2-24-1975',
      2.599258,
      32,
      ' 9-15-1981',
      NULL,
      13.420153,
      14,
      16.689469,
      12.129811,
      6,
      NULL,
      16,
      NULL,
      99.246506,
      6,
      NULL,
      NULL,
      23,
      3,
      NULL,
      NULL,
      0.556143,
      '11-22-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.364948,
      ' 6-29-2002',
      9.315653,
      ' 7-19-1981',
      5.852858,
      12,
      ' 3-13-1984',
      121.745075,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      27.579295,
      ' 5- 1-1999',
      34,
      17,
      45.915632,
      ' 7- 1-1991',
      1.681521,
      42.421384,
      '11-10-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


