set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028622';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2143',
      '32330201',
      '00123120',
      '12201143',
      '12241424',
      NULL,
      NULL,
      '22424231',
      '10143411',
      NULL,
      '23232203',
      '04442434',
      NULL,
      '11134132',
      '02234104',
      '02003412',
      '44314410',
      NULL,
      '02104331',
      '20111041',
      NULL,
      '34414214',
      '40111401',
      '30023322',
      '11242044',
      '13431203',
      '21403200',
      '11012201',
      NULL,
      '30400220',
      '00020021',
      NULL,
      '23243001',
      NULL,
      '21412210',
      NULL,
      NULL,
      '13043444',
      '42022121',
      '04304412',
      '40423301',
      NULL,
      '23114423',
      '14100201',
      '12234034',
      '324',
      '33',
      5.886627,
      NULL,
      '1241334',
      3.366817,
      1,
      3,
      NULL,
      '030340',
      NULL,
      ' 3-12-1984',
      NULL,
      NULL,
      11,
      19,
      12,
      NULL,
      3,
      9.392624,
      6,
      NULL,
      4.331501,
      NULL,
      10.703515,
      2.462365,
      2.114829,
      22,
      20.445300,
      NULL,
      NULL,
      49.597793,
      21,
      40,
      NULL,
      NULL,
      12.800522,
      0,
      24.747866,
      NULL,
      NULL,
      42,
      71.066721,
      147.082392,
      ' 4-26-1989',
      36,
      18.809999,
      27,
      16,
      213.346011,
      NULL,
      ' 6- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      30,
      23,
      9,
      10,
      6.002529,
      '11- 8-1983',
      2.689985,
      1.564884,
      51.987760,
      1,
      0,
      52.136284,
      0.845097,
      8,
      48.927187,
      NULL,
      NULL,
      NULL,
      ' 9-23-1996',
      47,
      75,
      95,
      20,
      NULL,
      20.792667,
      16.835616,
      10,
      77,
      56.787321,
      13.064279,
      NULL,
      ' 9- 1-1999',
      10,
      11,
      NULL,
      46.665795,
      33.805399,
      0.716382,
      11,
      ' 4- 2-1975',
      21,
      12,
      NULL,
      13.540406,
      13.022054,
      9,
      NULL,
      19,
      6,
      NULL,
      15.092955,
      1,
      27.030786,
      1,
      12,
      1.256066,
      4.450903,
      1.831369,
      NULL,
      NULL,
      0,
      ' 2-19-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      40.530195,
      0.558950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.619273,
      NULL,
      4,
      13,
      '11- 2-1987',
      58,
      121,
      ' 8-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      9.535789,
      NULL,
      37.009708,
      30,
      5.888588,
      ' 4-23-1986',
      1.671970,
      119.179858,
      '10-22-1984',
      13,
      10.997925,
      8.777226,
      63.421641,
      ' 7-11-1993',
      26,
      0.739526,
      NULL,
      ' 1-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


