set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028622';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3040',
      '02333342',
      '02414102',
      '01211111',
      '42143041',
      '43101313',
      '10244314',
      '12220033',
      NULL,
      '42131334',
      '03033030',
      '31424434',
      '33001031',
      '11321013',
      '32223001',
      '41144402',
      '12423211',
      '00431301',
      '11033143',
      '20220230',
      '14302213',
      NULL,
      NULL,
      '13210424',
      '42023414',
      '14111221',
      NULL,
      '10304020',
      '11431013',
      '30430224',
      NULL,
      NULL,
      '14332223',
      '14213040',
      '20424144',
      '23301022',
      '12243212',
      NULL,
      '24011431',
      NULL,
      '33343012',
      '04310331',
      '12444122',
      '23400410',
      NULL,
      '440',
      '00',
      24,
      7,
      NULL,
      3,
      48,
      NULL,
      NULL,
      '230230',
      4.536679,
      ' 8- 8-1999',
      ' 3- 5-1979',
      19,
      45,
      25,
      13,
      17,
      13.462825,
      65.017543,
      2.740378,
      NULL,
      3.765397,
      43.840310,
      6,
      24.295237,
      1.872689,
      12.268990,
      3.909806,
      4.955116,
      6,
      20.946521,
      0.691218,
      32.984926,
      21.703336,
      20.508339,
      NULL,
      1,
      NULL,
      43,
      75,
      85,
      NULL,
      195,
      NULL,
      43,
      7,
      18,
      18,
      45.678967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.750769,
      12.177122,
      NULL,
      9.900249,
      6.796211,
      NULL,
      '11-21-1991',
      0.980140,
      1,
      130,
      3.086219,
      0,
      NULL,
      0,
      8,
      30.993640,
      NULL,
      NULL,
      NULL,
      ' 9-27-1992',
      40.275976,
      NULL,
      NULL,
      40.789153,
      76.649678,
      NULL,
      7.705267,
      64,
      27.060911,
      NULL,
      42.385897,
      NULL,
      '11-16-1992',
      15.906294,
      3,
      NULL,
      4.344106,
      72.401073,
      67,
      3.023728,
      ' 1-22-1993',
      2.612478,
      21,
      ' 9-13-1983',
      6.122648,
      16,
      21.018391,
      9,
      2.346015,
      9.270819,
      0.789308,
      NULL,
      1,
      22.809689,
      0.382865,
      6.916537,
      5.030141,
      13.699950,
      3.114223,
      0,
      1,
      1.041198,
      ' 7- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      207.747564,
      16.498410,
      ' 0-24-1987',
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      '10-16-1998',
      NULL,
      11,
      ' 7- 7-1981',
      56,
      NULL,
      ' 6-16-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      26.011351,
      ' 8-17-1993',
      NULL,
      33,
      NULL,
      ' 6-29-2001',
      1.431684,
      54,
      ' 7-29-2000',
      5.772857,
      42,
      20,
      25.840461,
      ' 0-24-1994',
      5.449035,
      1.140261,
      150,
      ' 4-22-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


