set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8028622';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '1',
      '0',
      '3',
      '3',
      NULL,
      '4',
      NULL,
      '0',
      '4',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      '0',
      '4',
      '4',
      '2',
      '0',
      '0',
      NULL,
      '1',
      '',
      '2',
      '',
      '0',
      '2',
      '2',
      '4',
      '4',
      NULL,
      '',
      NULL,
      '2',
      '2',
      NULL,
      '1',
      NULL,
      '1',
      '1',
      '4',
      '2',
      NULL,
      NULL,
      '11220000',
      56.416194,
      65,
      '4210332',
      2.388948,
      102,
      3,
      NULL,
      '302142',
      0.823711,
      ' 3-19-1989',
      ' 8- 4-1991',
      48,
      229.342521,
      NULL,
      NULL,
      14.250309,
      15,
      32.841948,
      15.132003,
      9,
      NULL,
      NULL,
      2.915482,
      18,
      NULL,
      19.285888,
      18,
      6,
      21.285308,
      37.926132,
      8.913267,
      32.724292,
      0,
      11,
      2.224358,
      1.535065,
      96,
      NULL,
      NULL,
      197.138093,
      194.030231,
      74,
      ' 3-13-2000',
      48,
      49,
      22.842890,
      NULL,
      122.057119,
      124.393128,
      ' 6- 8-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.320604,
      NULL,
      NULL,
      5.216944,
      1.890874,
      NULL,
      ' 7- 5-1980',
      0,
      0,
      35,
      0,
      1,
      8.149901,
      0,
      3,
      78,
      NULL,
      NULL,
      NULL,
      ' 3-15-1989',
      93.944327,
      71.393092,
      61.282518,
      90.913628,
      59,
      90.892110,
      33.486602,
      11.793133,
      51.811083,
      14.919462,
      52,
      15,
      ' 6-24-2003',
      6,
      13,
      3,
      38,
      20,
      0,
      NULL,
      ' 9-22-1976',
      16,
      6,
      ' 5-21-1984',
      0,
      2.182989,
      18,
      13,
      NULL,
      5,
      1,
      12.332196,
      1,
      72,
      1,
      0.583090,
      12.653666,
      13.239689,
      1.524144,
      0.668523,
      1,
      NULL,
      ' 3-23-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      108,
      7.724716,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      ' 7-15-1993',
      0.039543,
      ' 1- 1-1982',
      6,
      2.834768,
      ' 4-15-1984',
      131.996411,
      90,
      ' 8-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 8-14-1974',
      NULL,
      NULL,
      28,
      '11-27-1976',
      1.199862,
      44.227536,
      NULL,
      6,
      18.180544,
      0,
      5.898382,
      ' 2- 0-1989',
      9.011489,
      0,
      135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


