set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3232',
      '14144134',
      '20114410',
      '31233034',
      '32412133',
      NULL,
      '01410203',
      '43124240',
      '13040041',
      '31012040',
      '13023300',
      '30014333',
      '22144041',
      '21103302',
      NULL,
      '43104131',
      '31240004',
      '42022444',
      '44013112',
      '04302022',
      NULL,
      '23431212',
      NULL,
      '23233134',
      '42023233',
      '23442101',
      NULL,
      '14304213',
      '13334314',
      '02242041',
      '04422002',
      '24403433',
      '01042241',
      '00341432',
      NULL,
      NULL,
      '43120140',
      NULL,
      '01012000',
      '22130332',
      NULL,
      '30111402',
      '20203104',
      '32314230',
      '32441211',
      '204',
      '13',
      23,
      6,
      '2211134',
      1.667802,
      0.689883,
      1,
      NULL,
      '412100',
      NULL,
      ' 7-17-1994',
      NULL,
      5.770977,
      91,
      22,
      3,
      14,
      NULL,
      54.455066,
      NULL,
      2,
      5,
      7,
      7.393612,
      4.771462,
      15.688346,
      4.634903,
      NULL,
      21.006396,
      4,
      25.479987,
      3.836458,
      37,
      NULL,
      45.476040,
      6,
      NULL,
      89.185578,
      NULL,
      12.025679,
      38.076038,
      65,
      NULL,
      NULL,
      0,
      36.095157,
      26,
      NULL,
      NULL,
      158.168871,
      ' 4- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.798074,
      14,
      22,
      4,
      15.972931,
      NULL,
      ' 4-12-1982',
      0,
      0.827153,
      118,
      1,
      0,
      79.671278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1999',
      49.664207,
      4.963112,
      NULL,
      90,
      81,
      99.121539,
      62.382373,
      NULL,
      NULL,
      18,
      24.689356,
      39,
      ' 6-10-1983',
      NULL,
      4.243086,
      27.420139,
      35.012232,
      NULL,
      32,
      9.787226,
      ' 7- 0-1996',
      3.833603,
      6,
      ' 2-22-1981',
      0,
      2,
      1.910208,
      0.145059,
      8.192777,
      6.648711,
      2.944428,
      1.910665,
      1.978018,
      51.226965,
      4.227937,
      5.124799,
      4.336738,
      16,
      7.933706,
      13,
      1.378598,
      4.431909,
      ' 5-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      5,
      ' 9- 1-2002',
      NULL,
      NULL,
      NULL,
      26.187515,
      ' 8-28-1994',
      26,
      ' 7-14-1998',
      NULL,
      7,
      ' 9- 6-1993',
      126,
      16.726722,
      ' 3-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      14.676719,
      ' 4-19-1990',
      49.380360,
      13.040244,
      NULL,
      ' 3-25-1989',
      0,
      129.699440,
      ' 5- 0-1991',
      13,
      25,
      NULL,
      42,
      NULL,
      20.680406,
      NULL,
      94,
      '11- 1-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


