set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '3',
      NULL,
      '3',
      '3',
      NULL,
      '1',
      '0',
      '3',
      '0',
      NULL,
      NULL,
      '4',
      '2',
      '4',
      NULL,
      '1',
      '3',
      '1',
      '0',
      '3',
      '3',
      '1',
      '',
      '1',
      '',
      '4',
      '4',
      '2',
      '1',
      '1',
      '',
      '',
      '3',
      '1',
      '3',
      '1',
      '0',
      '1',
      '1',
      NULL,
      '0',
      '0',
      '1',
      '300',
      '32',
      14,
      27.456035,
      '1324320',
      0,
      19.333190,
      3,
      NULL,
      NULL,
      5.567820,
      ' 7- 3-1979',
      NULL,
      76.343722,
      229,
      NULL,
      9,
      NULL,
      10.509044,
      21,
      NULL,
      NULL,
      22,
      3.466574,
      5,
      27,
      15.693640,
      17,
      10,
      25,
      0.376801,
      50,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      1,
      104.398509,
      39,
      56.578964,
      59.867646,
      124,
      NULL,
      ' 4- 2-1977',
      32,
      50,
      18,
      8.995431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      11.707691,
      8,
      13.844546,
      9.771504,
      ' 8-18-1990',
      NULL,
      1,
      111.204025,
      1.796792,
      0.113761,
      82.839530,
      1,
      1.933900,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-29-1997',
      18,
      82,
      9.327038,
      46,
      41,
      NULL,
      14.839231,
      51,
      50,
      NULL,
      6.728031,
      49.907755,
      NULL,
      NULL,
      20.485144,
      13.674351,
      12,
      93,
      133,
      0.290544,
      NULL,
      6,
      11,
      ' 2-26-1999',
      9,
      6.446578,
      NULL,
      NULL,
      0,
      9.300477,
      0,
      1,
      0,
      56,
      1,
      3,
      3,
      9.561369,
      0,
      6,
      10.328014,
      2.772959,
      ' 4- 1-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      82.364884,
      9.520408,
      ' 5-27-1980',
      NULL,
      NULL,
      NULL,
      3.883852,
      ' 2- 6-2001',
      38.147142,
      NULL,
      NULL,
      6,
      ' 1- 4-1987',
      112,
      104.633953,
      ' 4-23-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      54.551861,
      23.745795,
      11,
      NULL,
      1.103426,
      77,
      ' 5- 5-1983',
      9.901216,
      4,
      7,
      6.191347,
      ' 1- 8-2002',
      30.846544,
      1,
      NULL,
      '11-14-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


