set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9656604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      '4',
      '3',
      '4',
      '1',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      '2',
      '2',
      '2',
      '1',
      '2',
      '3',
      '0',
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '2',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      '1',
      '4',
      '4',
      '0',
      '2',
      '0',
      NULL,
      '210',
      '20232331',
      70,
      NULL,
      '1144422',
      0.874838,
      117.696954,
      3,
      1,
      '324321',
      4,
      ' 2- 1-1986',
      ' 2- 2-1978',
      48.480771,
      93.136026,
      28.794019,
      NULL,
      NULL,
      21.928148,
      61,
      NULL,
      NULL,
      NULL,
      11.259142,
      11,
      20,
      7.831934,
      18,
      6,
      35.676427,
      17.230982,
      NULL,
      7.343101,
      42.850809,
      8.333210,
      70.583997,
      12.535137,
      1,
      94,
      69,
      NULL,
      NULL,
      47.072374,
      33.884649,
      ' 6- 7-2003',
      13.256532,
      NULL,
      NULL,
      17.578841,
      125,
      160.989265,
      '10-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4,
      4.666157,
      0.826193,
      6.801219,
      ' 5- 9-2000',
      0.436492,
      NULL,
      NULL,
      0,
      0,
      65.276061,
      0.956368,
      2.131101,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-15-1982',
      NULL,
      NULL,
      6.613263,
      NULL,
      1.793390,
      79.217744,
      21,
      36,
      48.460646,
      42,
      35.236197,
      11,
      ' 8-25-1978',
      6,
      0.712892,
      4,
      82.206111,
      65,
      32,
      11,
      ' 8- 1-1989',
      21.503625,
      1,
      NULL,
      1.488887,
      7,
      8.869509,
      NULL,
      10,
      2.237141,
      0,
      6.916673,
      NULL,
      12.610413,
      4.284091,
      1,
      10.826189,
      15,
      2,
      5,
      11.679303,
      NULL,
      ' 4- 0-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.686449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1994',
      22.041797,
      NULL,
      4.308550,
      NULL,
      ' 5- 4-1995',
      24.460838,
      24.319837,
      ' 2-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.166794,
      3.237093,
      17.225018,
      ' 0-19-2002',
      3,
      104.323405,
      ' 4-22-1994',
      NULL,
      6.924477,
      14,
      119,
      ' 8-13-1995',
      43,
      NULL,
      146,
      ' 9-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


