set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0108712';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '4',
      '0',
      NULL,
      NULL,
      '0',
      '2',
      '1',
      '2',
      '3',
      '1',
      '3',
      '1',
      '2',
      '0',
      '0',
      '1',
      '2',
      '1',
      '4',
      '0',
      '1',
      '4',
      '',
      '4',
      '',
      NULL,
      '2',
      '3',
      '4',
      '1',
      '',
      '',
      '1',
      '3',
      '2',
      NULL,
      '2',
      NULL,
      NULL,
      '3',
      '1',
      '3',
      '1',
      NULL,
      '22222210',
      24,
      79,
      '4034042',
      NULL,
      1,
      3,
      1,
      '214123',
      1.965852,
      ' 8- 0-1998',
      ' 7-20-1977',
      NULL,
      176,
      16.895830,
      21,
      17.083600,
      0.766745,
      NULL,
      1,
      7,
      NULL,
      NULL,
      0.860332,
      16.127636,
      NULL,
      6,
      NULL,
      0,
      9.639515,
      16,
      18,
      5.826638,
      0.292397,
      NULL,
      12,
      1.337260,
      33,
      82,
      29,
      55.590020,
      148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.853498,
      72.958774,
      124.108648,
      ' 3- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32,
      36,
      34.694573,
      1,
      15,
      5,
      ' 7-28-1980',
      2.749682,
      0,
      NULL,
      NULL,
      NULL,
      117,
      0,
      18.119196,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      132.212594,
      58.668796,
      13,
      27,
      8.204529,
      32,
      79,
      70.749683,
      21.489637,
      29.512511,
      ' 8-26-1993',
      10,
      8.197614,
      6.707826,
      5,
      NULL,
      105,
      3.892664,
      '11-16-1989',
      6.443253,
      10,
      ' 4-18-1994',
      4.408013,
      0,
      0,
      8.230811,
      6.046688,
      2,
      2,
      3,
      0.866408,
      44.624555,
      NULL,
      0,
      3.081794,
      6.108271,
      6,
      8.003990,
      0,
      2,
      ' 1-16-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      163.025459,
      21.370028,
      '10- 2-1975',
      NULL,
      NULL,
      NULL,
      13,
      ' 3-14-1997',
      NULL,
      ' 7- 2-1976',
      2,
      13,
      '11-21-1993',
      158,
      92,
      ' 5-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      17,
      ' 8-10-1983',
      40,
      36.400519,
      23,
      NULL,
      1,
      17,
      '11-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


