set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8807476';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4141',
      NULL,
      '21214023',
      '32010112',
      '34441321',
      '33410103',
      '44042334',
      '10020230',
      '34210122',
      '20312233',
      '30103210',
      '41124023',
      '11404203',
      '30422340',
      '21310403',
      '21102134',
      '22433134',
      '02441304',
      NULL,
      '10132300',
      '40202442',
      '41410302',
      '04312212',
      '31443200',
      NULL,
      '24132023',
      '42142414',
      '40020201',
      '20034001',
      '02321102',
      '22143432',
      '01213430',
      '01421314',
      '43120420',
      '22421330',
      '24134034',
      '34200401',
      '04323004',
      '00041012',
      '01304013',
      '43414233',
      '44212310',
      '32144211',
      '01120003',
      '21110424',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      0.058168,
      1.829431,
      3,
      NULL,
      '123024',
      3.576570,
      ' 1-10-1989',
      '10- 6-1999',
      11.758311,
      NULL,
      NULL,
      NULL,
      11,
      4,
      33,
      5,
      10.687490,
      5,
      10.272951,
      3.540770,
      27.106772,
      5,
      17,
      3.115295,
      25.057081,
      13,
      15.618271,
      5.791842,
      19.861238,
      NULL,
      36.309923,
      1,
      NULL,
      5.246025,
      144,
      23.377101,
      13,
      NULL,
      35.378231,
      ' 9- 0-2001',
      NULL,
      25.583966,
      24.950904,
      1,
      27,
      NULL,
      ' 2- 6-1976',
      4.596339,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535846,
      1.817242,
      3,
      NULL,
      1,
      0.577570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 5-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-27-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      116.486603,
      49,
      81.263053,
      7,
      27.201686,
      71,
      ' 9-29-1990',
      NULL,
      17.517428,
      22,
      NULL,
      74.984169,
      36.001712,
      0,
      ' 4- 4-1975',
      2.992758,
      10,
      NULL,
      1,
      NULL,
      6,
      3.420727,
      10.722909,
      6,
      NULL,
      6,
      NULL,
      12,
      1,
      1,
      5.771718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-11-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.380096,
      29,
      16,
      ' 1-19-1998',
      1.670248,
      134,
      ' 6- 2-1999',
      8.075029,
      38.133698,
      NULL,
      38,
      NULL,
      NULL,
      1,
      56.880141,
      NULL,
      NULL,
      NULL,
      NULL,
      13.531443,
      NULL,
      NULL,
      2,
      NULL,
      74.682788,
      104.526416,
      50.437397,
      31.232506,
      101.033574,
      2,
      60.793987,
      NULL,
      1.105329,
      28,
      1,
      0,
      NULL,
      0,
      NULL,
      140,
      0.080262,
      3,
      444.954205,
      28.706863,
      NULL,
      NULL,
      1.858331,
      54,
      0,
      NULL,
      0,
      3,
      0.914827,
      0.012471,
      34.384250,
      19,
      NULL,
      0,
      49.992556,
      19,
      3.687221,
      1.948435,
      NULL,
      86,
      NULL,
      14,
      31.861167,
      4.669679,
      5.957696,
      1.025864,
      58,
      NULL,
      0,
      3,
      NULL,
      7,
      33,
      2,
      7,
      2,
      14,
      1,
      2,
      0.486908,
      12.133500,
      NULL,
      0,
      0,
      5,
      71,
      '10- 9-1992',
      NULL,
      ' 0-20-1987',
      NULL,
      NULL,
      ' 2- 1-1995',
      ' 2-18-1981',
      NULL);
commit;
end;
/


