set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9224741';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40110010',
      NULL,
      '04314014',
      '43330142',
      NULL,
      '01031202',
      '14334423',
      NULL,
      NULL,
      '42213412',
      '31131012',
      NULL,
      '14130300',
      '02104030',
      '02230421',
      '32204220',
      '31224140',
      '43241310',
      NULL,
      '22112302',
      '13434300',
      '12011430',
      '01343310',
      '40331403',
      '13124342',
      '23020203',
      '40112021',
      '12443411',
      NULL,
      '33020211',
      '20242344',
      '33221010',
      '00130031',
      NULL,
      '01434312',
      '14221203',
      '04234301',
      '20412021',
      '24303334',
      '23113042',
      NULL,
      NULL,
      NULL,
      NULL,
      '113',
      NULL,
      NULL,
      NULL,
      '4022023',
      2,
      1,
      NULL,
      NULL,
      '423022',
      5.817254,
      '11-19-2001',
      NULL,
      20,
      NULL,
      42.737326,
      12.798655,
      13.364871,
      12,
      NULL,
      20,
      21.193743,
      NULL,
      NULL,
      25,
      10.784510,
      13.922224,
      31.037809,
      3.941541,
      7.268179,
      4.763041,
      34,
      5.500877,
      NULL,
      11.459660,
      116,
      17.126662,
      2.937288,
      NULL,
      97,
      80.266874,
      206,
      228,
      137,
      ' 1-11-1989',
      NULL,
      51,
      34.521095,
      NULL,
      126,
      112.880331,
      ' 3-22-1994',
      0,
      0.036603,
      4.786240,
      1,
      NULL,
      NULL,
      3,
      1.084414,
      0.196092,
      NULL,
      NULL,
      NULL,
      0,
      1.003528,
      NULL,
      NULL,
      0,
      0,
      0.776162,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1977',
      37,
      18,
      9.451532,
      0.176212,
      4,
      4,
      ' 1- 3-1988',
      1.999395,
      NULL,
      165.992576,
      1.524616,
      0,
      35.333787,
      1.227068,
      1.989580,
      14,
      1,
      1.987509,
      206.509117,
      ' 3- 2-1974',
      65.633706,
      NULL,
      76.357157,
      3.797311,
      71.774607,
      32,
      111.796161,
      NULL,
      NULL,
      76,
      68,
      99,
      ' 0- 3-1985',
      NULL,
      23.660441,
      5,
      69,
      64.315311,
      51.646826,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-21-1991',
      11.605973,
      18.013474,
      6,
      2.124326,
      12.446361,
      NULL,
      1.494869,
      13.881674,
      NULL,
      NULL,
      0.813876,
      6,
      7.866234,
      24,
      1.318665,
      NULL,
      0.430409,
      1,
      '11-12-1982',
      11.083170,
      1,
      NULL,
      NULL,
      NULL,
      0.586036,
      ' 3-27-1991',
      0.871432,
      8.279566,
      NULL,
      NULL,
      '10-27-1999',
      10,
      NULL,
      19,
      8.653665,
      ' 1-27-1982',
      NULL,
      14.649945,
      NULL,
      NULL,
      0.938764,
      ' 5-21-1996',
      5.931163,
      12,
      ' 0-11-1992',
      2,
      NULL,
      NULL,
      NULL,
      1,
      49,
      5,
      ' 6-16-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7);
commit;
end;
/


