set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4005977';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21123413',
      '43114440',
      NULL,
      '24344404',
      '20002110',
      '10003111',
      '20213243',
      '42020231',
      '41440200',
      '10042430',
      NULL,
      '44301324',
      '21010024',
      '32314320',
      '11114340',
      '22111321',
      '30201124',
      '40203132',
      '20333200',
      NULL,
      '11121440',
      '24341430',
      '44413223',
      '01044121',
      NULL,
      '02211402',
      '30313434',
      '12240243',
      '03301233',
      '01122143',
      '02224301',
      '01441141',
      '14004443',
      '00431134',
      '11124042',
      '01200424',
      '43232321',
      '41421133',
      '20422110',
      '22431223',
      '30033320',
      '31144440',
      '21333123',
      NULL,
      '034',
      '04',
      NULL,
      NULL,
      '1413401',
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      '10-20-1983',
      '11-13-1992',
      NULL,
      NULL,
      43,
      20.794661,
      5,
      4,
      46.036764,
      2,
      18.350817,
      7,
      NULL,
      20.521052,
      18,
      NULL,
      8,
      18.618927,
      NULL,
      1.539098,
      34,
      4.867083,
      9.135376,
      NULL,
      83.783463,
      NULL,
      0,
      32,
      170,
      NULL,
      NULL,
      NULL,
      37.878875,
      ' 5-11-1999',
      35,
      14,
      NULL,
      25.076914,
      31,
      230.140538,
      ' 1- 6-2002',
      9.150181,
      7,
      NULL,
      2.664052,
      9,
      1,
      7.651623,
      3,
      0.867306,
      0.797542,
      9.180666,
      1.711234,
      0.217321,
      NULL,
      1,
      1,
      NULL,
      0.871442,
      1.475449,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-2003',
      79,
      16.120773,
      6.279143,
      5.521359,
      2,
      9.082748,
      ' 2- 9-1979',
      1.988339,
      5,
      103.587633,
      0.353530,
      5.950118,
      52.394256,
      0.245274,
      1,
      19,
      NULL,
      NULL,
      NULL,
      ' 4- 0-1985',
      7,
      75,
      NULL,
      39,
      75.700513,
      53,
      15,
      21.530860,
      26,
      62,
      18.944394,
      53,
      ' 0-15-1983',
      8.363494,
      8.419612,
      NULL,
      NULL,
      40,
      5,
      0.126321,
      ' 1-29-1997',
      15,
      9,
      ' 0-28-2001',
      0,
      8,
      NULL,
      4.240822,
      NULL,
      NULL,
      NULL,
      13,
      0.718135,
      62.223400,
      1,
      1,
      0.233128,
      23,
      NULL,
      1.566771,
      1.867141,
      2,
      ' 5-14-1978',
      2,
      0.118373,
      NULL,
      ' 4-21-1987',
      64,
      4,
      ' 9- 6-1999',
      NULL,
      NULL,
      NULL,
      25.612085,
      NULL,
      33,
      '10-12-1990',
      7,
      1.319209,
      ' 5-10-2003',
      43.048659,
      21.446942,
      NULL,
      1.084081,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      8,
      '11- 5-1979',
      61.841289,
      10,
      38,
      '11-14-1979',
      3,
      NULL,
      ' 2- 2-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.132856);
commit;
end;
/


