set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9716576';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      '2',
      '4',
      '1',
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      '4',
      '2',
      NULL,
      '4',
      '0',
      '3',
      '2',
      '2',
      '2',
      '',
      '2',
      NULL,
      '4',
      '4',
      NULL,
      '2',
      '0',
      NULL,
      '',
      '2',
      '4',
      '3',
      '2',
      NULL,
      '3',
      NULL,
      '4',
      '3',
      '3',
      NULL,
      '013',
      NULL,
      9,
      60,
      '0131312',
      2.754456,
      1,
      3,
      NULL,
      '210232',
      3.399559,
      '11- 5-1975',
      ' 1-24-1978',
      56.427847,
      0,
      33.700214,
      NULL,
      14.548510,
      0,
      52,
      1.845223,
      4,
      7.438588,
      12,
      3.445623,
      NULL,
      9,
      11,
      14,
      0.023678,
      3.613463,
      49,
      13.665902,
      26,
      NULL,
      54.648584,
      6.713948,
      NULL,
      87,
      NULL,
      51,
      44,
      58.548235,
      34,
      ' 3-16-2001',
      9.071126,
      51.868926,
      28,
      8.196273,
      22.034339,
      149,
      ' 0-22-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      44.187383,
      2.178040,
      2,
      13,
      7,
      0.604925,
      ' 8- 9-1980',
      0,
      NULL,
      62,
      0.133109,
      2,
      193.489514,
      3.029455,
      1.854734,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.347294,
      77,
      NULL,
      103.018882,
      80,
      44.034877,
      41.255978,
      78,
      62,
      NULL,
      17,
      45.730701,
      ' 8-22-1980',
      5.803935,
      NULL,
      16,
      NULL,
      64.327678,
      8,
      8,
      ' 2-17-1982',
      8,
      NULL,
      '10-10-1978',
      6,
      1.011736,
      9,
      5.899520,
      6,
      3,
      1,
      NULL,
      1,
      37,
      0,
      0,
      NULL,
      18.239152,
      0.329388,
      1.806805,
      0,
      NULL,
      ' 4-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      8.133531,
      ' 8-28-1977',
      NULL,
      NULL,
      NULL,
      14,
      ' 9-19-1985',
      39,
      ' 7- 3-1993',
      NULL,
      7,
      ' 8-24-1978',
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      13,
      ' 9- 7-1996',
      54,
      10,
      39.881046,
      ' 2-21-1991',
      1,
      87.971339,
      '11-12-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


