set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5112208';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '42021014',
      NULL,
      '13303324',
      '01243034',
      '40313224',
      '24231100',
      '32134424',
      '40301211',
      '31432030',
      '23044221',
      NULL,
      '30243113',
      '31222430',
      NULL,
      '42420423',
      '03044410',
      '32043442',
      '33401420',
      '32211021',
      '30441302',
      '13321231',
      NULL,
      NULL,
      '04141422',
      NULL,
      '00404424',
      '32111033',
      '00442111',
      NULL,
      '11112241',
      '42200413',
      '10344003',
      NULL,
      '43022233',
      NULL,
      '03232240',
      '32432420',
      '42014142',
      '42202321',
      NULL,
      NULL,
      '22001131',
      '21121004',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '2020314',
      3,
      0,
      0,
      NULL,
      '100123',
      2,
      ' 7-10-1985',
      ' 3-19-1981',
      NULL,
      NULL,
      35.758766,
      1,
      2,
      9,
      104,
      4,
      NULL,
      6.074427,
      21.609832,
      7,
      32,
      27.213515,
      16,
      21,
      27,
      31,
      26,
      3.850244,
      42.693949,
      18.464584,
      50.737028,
      NULL,
      NULL,
      43.872589,
      148,
      91.952822,
      60.155259,
      67,
      59,
      ' 1-29-1987',
      10.505740,
      45,
      8.702998,
      17.368454,
      NULL,
      7.636557,
      ' 2-19-1980',
      0.352137,
      5,
      NULL,
      3.298900,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.250080,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-12-1984',
      96.221691,
      92,
      98,
      71.203128,
      68.131079,
      37,
      41.887889,
      88.760845,
      82.664371,
      36.954566,
      30,
      NULL,
      ' 6-20-1982',
      NULL,
      5.019901,
      33.534068,
      NULL,
      NULL,
      NULL,
      11,
      ' 0-19-1983',
      NULL,
      13,
      ' 7- 5-1977',
      8.950723,
      0,
      6,
      21.531001,
      5.153172,
      2,
      NULL,
      NULL,
      NULL,
      57,
      3.370225,
      NULL,
      11.747897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31.815897,
      10,
      4.158285,
      ' 7-20-1983',
      1.688870,
      23.180360,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      ' 5- 0-1989',
      26,
      NULL,
      68,
      ' 8-24-1989',
      NULL,
      NULL,
      NULL,
      0.765768,
      NULL,
      172,
      77.496486,
      NULL,
      118.268424,
      1.992436,
      5,
      4,
      1.740250,
      1,
      49,
      1.632302,
      0.626915,
      35,
      0.866373,
      NULL,
      61,
      0,
      1,
      73,
      0.041129,
      1.537107,
      120.741532,
      10.463192,
      18,
      NULL,
      NULL,
      70,
      NULL,
      0.238411,
      1,
      NULL,
      1,
      0,
      17,
      1,
      68.749081,
      6.101896,
      60,
      58.676713,
      NULL,
      7.147170,
      15,
      0,
      NULL,
      NULL,
      26,
      2.647072,
      75,
      NULL,
      20,
      NULL,
      1.683483,
      46,
      22.389174,
      12,
      31,
      78,
      79,
      NULL,
      36.961173,
      13.036254,
      15.588840,
      0,
      1,
      0,
      0.114893,
      0.196016,
      5,
      42,
      ' 5- 7-1975',
      ' 1-17-1976',
      ' 8-28-1997',
      ' 7-25-1990',
      ' 7-27-2001',
      NULL,
      '11-23-1994',
      NULL);
commit;
end;
/


