set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9757573';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      '0',
      '4',
      '3',
      '2',
      '4',
      '0',
      '3',
      '1',
      '2',
      '0',
      '0',
      '2',
      NULL,
      '1',
      '3',
      '1',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      '',
      '2',
      NULL,
      '1',
      '1',
      '2',
      NULL,
      '1',
      '',
      '',
      '0',
      '1',
      '0',
      '2',
      '2',
      '2',
      '2',
      '0',
      '0',
      '0',
      '0',
      '211',
      '01312432',
      7,
      12.508892,
      '3140221',
      0.940270,
      1.494213,
      3,
      NULL,
      NULL,
      1,
      NULL,
      ' 4- 2-1990',
      NULL,
      NULL,
      18.234282,
      8.388524,
      25,
      7.085323,
      28,
      NULL,
      3,
      10,
      11.600559,
      9.321693,
      27,
      12,
      1,
      NULL,
      15.180670,
      10,
      NULL,
      12.516956,
      33,
      10.401057,
      38,
      5,
      1,
      89.239819,
      31.602998,
      52.777047,
      NULL,
      94,
      163.646833,
      ' 1- 4-1990',
      NULL,
      21,
      4,
      24.889243,
      206,
      114.685706,
      ' 5-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.249420,
      NULL,
      14,
      NULL,
      14.108637,
      NULL,
      ' 0-14-1997',
      NULL,
      NULL,
      1,
      NULL,
      0.533946,
      NULL,
      1,
      2.410884,
      68,
      NULL,
      NULL,
      NULL,
      ' 4-10-1974',
      78.668046,
      24.320321,
      60.037191,
      NULL,
      112.019392,
      108.716622,
      107.114638,
      100.724404,
      75.379236,
      89.797825,
      45.722828,
      0,
      '11-17-1992',
      17.640039,
      NULL,
      11,
      64,
      9.409636,
      NULL,
      9.978892,
      '10-25-1982',
      NULL,
      1,
      ' 3- 6-1982',
      1,
      7.910658,
      NULL,
      1,
      10,
      13,
      0.083371,
      17,
      0.830768,
      34.663303,
      0,
      NULL,
      13.382664,
      3.215439,
      1.325471,
      0.892614,
      0.408506,
      0,
      ' 9-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-10-1975',
      NULL,
      NULL,
      NULL,
      40.052921,
      ' 3-17-1980',
      25,
      ' 0-29-1993',
      NULL,
      NULL,
      ' 8-19-1993',
      120,
      94,
      '11- 6-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      11,
      NULL,
      55.043422,
      26,
      24.067512,
      NULL,
      1.812636,
      9.606115,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


