set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8329418';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '1',
      '3',
      '1',
      '2',
      '2',
      '0',
      '3',
      NULL,
      '4',
      '1',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      '4',
      '2',
      '3',
      '0',
      '2',
      '',
      '0',
      '',
      '4',
      '1',
      '1',
      NULL,
      '2',
      '',
      '',
      '0',
      '4',
      '0',
      '3',
      '1',
      '1',
      '2',
      '0',
      '1',
      '4',
      '3',
      '030',
      '40423040',
      25.570503,
      NULL,
      NULL,
      1.039264,
      1,
      2,
      NULL,
      '334430',
      NULL,
      ' 7-13-1981',
      ' 7- 7-1991',
      NULL,
      18,
      36,
      6.829920,
      3,
      6,
      34,
      NULL,
      22.824671,
      0,
      17.973012,
      23,
      14.143545,
      2,
      12.315763,
      9,
      15.018905,
      7,
      NULL,
      NULL,
      4.612454,
      3.401247,
      48,
      NULL,
      NULL,
      109,
      67,
      2,
      NULL,
      167,
      30.664521,
      '10- 4-1984',
      13,
      NULL,
      0,
      37,
      131.970043,
      79.051657,
      ' 4- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149168,
      8.925683,
      1,
      1.316986,
      0,
      11,
      ' 9-27-1997',
      1,
      1,
      189,
      0,
      0.759022,
      NULL,
      1,
      NULL,
      89,
      NULL,
      NULL,
      NULL,
      ' 3-27-2000',
      NULL,
      19,
      38,
      69.003503,
      32,
      68,
      107.581435,
      39,
      0,
      NULL,
      93.141733,
      7.162596,
      NULL,
      21.156987,
      19,
      15,
      18,
      NULL,
      20,
      5.031895,
      NULL,
      25,
      15,
      ' 4-24-1998',
      NULL,
      0.079227,
      16,
      13,
      NULL,
      0,
      0.710905,
      13,
      0,
      21,
      2.545185,
      NULL,
      17,
      NULL,
      NULL,
      0,
      NULL,
      1.456459,
      '10-23-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      NULL,
      0,
      ' 5-28-1985',
      NULL,
      15,
      ' 5-12-1997',
      83,
      61,
      ' 8- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      19.324893,
      ' 4-16-1982',
      47.056594,
      26,
      0.982542,
      ' 9- 3-1994',
      NULL,
      84,
      ' 6- 4-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


