set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531493';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1230',
      NULL,
      '20403112',
      '10224233',
      '14342313',
      '41021144',
      '23233033',
      NULL,
      '44244012',
      '23001423',
      '42041110',
      '32032011',
      NULL,
      '02321003',
      '22320141',
      '30114034',
      NULL,
      '44142404',
      '22300413',
      '43001024',
      '13024310',
      '03004343',
      '22142420',
      '24313242',
      '03321114',
      NULL,
      '02230030',
      '44311420',
      '33330123',
      '13444114',
      '12344110',
      '33022340',
      '30041020',
      '44413331',
      '03042312',
      '04000041',
      '20120030',
      '32313222',
      '31322303',
      '41123123',
      '42304011',
      '00001322',
      '22030232',
      '40330200',
      '01021423',
      NULL,
      '01',
      NULL,
      NULL,
      '2202144',
      NULL,
      0,
      3,
      NULL,
      NULL,
      2.478781,
      NULL,
      NULL,
      128.681251,
      NULL,
      47.751775,
      23,
      2,
      NULL,
      42.469272,
      29.094702,
      26,
      16.937298,
      2,
      21,
      NULL,
      NULL,
      34,
      17.171064,
      27,
      14,
      NULL,
      12,
      33.882542,
      16,
      61,
      28.977769,
      1,
      132.547696,
      219.322668,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-2001',
      50.004032,
      30,
      NULL,
      37.885219,
      104,
      248.823279,
      ' 4-16-1991',
      NULL,
      3,
      2,
      0.243817,
      0,
      2,
      1,
      3.257785,
      1,
      0,
      2.344430,
      1,
      1.411792,
      0,
      1,
      0,
      NULL,
      0.049056,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-21-1974',
      5.170008,
      NULL,
      6,
      1,
      11.754375,
      0,
      NULL,
      1.140316,
      2,
      NULL,
      1.761979,
      1.779984,
      72.756905,
      0.326963,
      5.925732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.605001,
      76.179559,
      96,
      98,
      18,
      93,
      95,
      87,
      1.098953,
      97,
      18,
      81.248366,
      NULL,
      NULL,
      7.793140,
      10,
      17.156036,
      89,
      166.251825,
      10.966079,
      ' 5-16-2002',
      12,
      29.852254,
      ' 3-14-1999',
      17,
      11.037907,
      4,
      7,
      10.145190,
      NULL,
      1.156765,
      0.925920,
      0.588808,
      49,
      1,
      3.440099,
      1.992686,
      NULL,
      1.381710,
      1.329408,
      NULL,
      NULL,
      ' 5-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      35.250562,
      1.463148,
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      ' 6-24-1993',
      22.267504,
      ' 6- 5-1974',
      6.791315,
      9,
      ' 4- 9-1984',
      NULL,
      NULL,
      NULL,
      11,
      2.279739,
      '11- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      ' 5- 2-1987',
      NULL,
      34.030443,
      NULL,
      '10- 9-1994',
      NULL,
      NULL,
      ' 0-24-2002',
      NULL,
      21,
      16,
      19.162372,
      ' 3- 3-2000',
      16.810375,
      1,
      62,
      ' 8-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


